/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.algorithms.ProbabilisticModel;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.mcmc.ProposalRejectionStrategy;
import io.improbable.keanu.algorithms.mcmc.proposal.Proposal;
import io.improbable.keanu.algorithms.mcmc.proposal.ProposalDistribution;
import io.improbable.keanu.vertices.ProbabilityCalculator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetropolisHastingsStep {
    private static final Logger log = LoggerFactory.getLogger(MetropolisHastingsStep.class);
    private static final double DEFAULT_TEMPERATURE = 1.0;
    private final ProbabilisticModel model;
    private final ProposalDistribution proposalDistribution;
    private final ProposalRejectionStrategy rejectionStrategy;
    private final KeanuRandom random;

    MetropolisHastingsStep(ProbabilisticModel model, ProposalDistribution proposalDistribution, ProposalRejectionStrategy rejectionStrategy, KeanuRandom random) {
        this.model = model;
        this.proposalDistribution = proposalDistribution;
        this.rejectionStrategy = rejectionStrategy;
        this.random = random;
    }

    public StepResult step(Set<Variable> chosenVariables, double logProbabilityBeforeStep) {
        return this.step(chosenVariables, logProbabilityBeforeStep, 1.0);
    }

    public StepResult step(Set<Variable> chosenVariables, double logProbabilityBeforeStep, double temperature) {
        Proposal proposal = this.proposalDistribution.getProposal(chosenVariables, this.random);
        this.rejectionStrategy.onProposalCreated(proposal);
        double logProbabilityAfterStep = this.model.logProbAfter(proposal.getProposalTo(), logProbabilityBeforeStep);
        if (!ProbabilityCalculator.isImpossibleLogProb(logProbabilityAfterStep)) {
            boolean shouldAccept;
            double pqxNew;
            double annealFactor = 1.0 / temperature;
            double logProbabilityDelta = logProbabilityAfterStep - logProbabilityBeforeStep;
            double pqxOld = this.proposalDistribution.logProbAtFromGivenTo(proposal);
            double hastingsCorrection = pqxOld - (pqxNew = this.proposalDistribution.logProbAtToGivenFrom(proposal));
            double logR = annealFactor * logProbabilityDelta + hastingsCorrection;
            double r = Math.exp(logR);
            boolean bl = shouldAccept = r >= this.random.nextDouble();
            if (shouldAccept) {
                return new StepResult(true, logProbabilityAfterStep);
            }
        }
        this.proposalDistribution.onProposalRejected();
        this.rejectionStrategy.onProposalRejected(proposal);
        return new StepResult(false, logProbabilityBeforeStep);
    }

    static final class StepResult {
        private final boolean accepted;
        private final double logProbabilityAfterStep;

        public StepResult(boolean accepted, double logProbabilityAfterStep) {
            this.accepted = accepted;
            this.logProbabilityAfterStep = logProbabilityAfterStep;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public double getLogProbabilityAfterStep() {
            return this.logProbabilityAfterStep;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StepResult)) {
                return false;
            }
            StepResult other = (StepResult)o;
            if (this.isAccepted() != other.isAccepted()) {
                return false;
            }
            return Double.compare(this.getLogProbabilityAfterStep(), other.getLogProbabilityAfterStep()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAccepted() ? 79 : 97);
            long $logProbabilityAfterStep = Double.doubleToLongBits(this.getLogProbabilityAfterStep());
            result = result * 59 + (int)($logProbabilityAfterStep >>> 32 ^ $logProbabilityAfterStep);
            return result;
        }

        public String toString() {
            return "MetropolisHastingsStep.StepResult(accepted=" + this.isAccepted() + ", logProbabilityAfterStep=" + this.getLogProbabilityAfterStep() + ")";
        }
    }
}

