/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc;

import io.improbable.keanu.algorithms.NetworkSample;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.algorithms.mcmc.MetropolisHastingsStep;
import io.improbable.keanu.algorithms.mcmc.SamplingAlgorithm;
import io.improbable.keanu.algorithms.mcmc.SamplingUtil;
import io.improbable.keanu.algorithms.mcmc.proposal.MHStepVariableSelector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetropolisHastingsSampler
implements SamplingAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(MetropolisHastingsSampler.class);
    private final List<? extends Variable> latentVariables;
    private final List<? extends Variable> variablesToSampleFrom;
    private final MetropolisHastingsStep mhStep;
    private final MHStepVariableSelector variableSelector;
    private double logProbabilityBeforeStep;
    private int sampleNum;

    public MetropolisHastingsSampler(List<? extends Variable> latentVariables, List<? extends Variable> variablesToSampleFrom, MetropolisHastingsStep mhStep, MHStepVariableSelector variableSelector, double logProbabilityBeforeStep) {
        this.latentVariables = latentVariables;
        this.variablesToSampleFrom = variablesToSampleFrom;
        this.mhStep = mhStep;
        this.variableSelector = variableSelector;
        this.logProbabilityBeforeStep = logProbabilityBeforeStep;
        this.sampleNum = 0;
    }

    @Override
    public void step() {
        Set<Variable> chosenVariables = this.variableSelector.select(this.latentVariables, this.sampleNum);
        this.logProbabilityBeforeStep = this.mhStep.step(chosenVariables, this.logProbabilityBeforeStep).getLogProbabilityAfterStep();
        ++this.sampleNum;
    }

    @Override
    public void sample(Map<VariableReference, List<?>> samplesByVariable, List<Double> logOfMasterPForEachSample) {
        this.step();
        SamplingUtil.takeSamples(samplesByVariable, this.variablesToSampleFrom);
        logOfMasterPForEachSample.add(this.logProbabilityBeforeStep);
    }

    @Override
    public NetworkSample sample() {
        this.step();
        return new NetworkSample(SamplingAlgorithm.takeSample(this.variablesToSampleFrom), this.logProbabilityBeforeStep);
    }
}

