/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.mcmc;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.algorithms.NetworkSamples;
import io.improbable.keanu.algorithms.PosteriorSamplingAlgorithm;
import io.improbable.keanu.algorithms.ProbabilisticModel;
import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.mcmc.MetropolisHastingsSampler;
import io.improbable.keanu.algorithms.mcmc.MetropolisHastingsStep;
import io.improbable.keanu.algorithms.mcmc.NetworkSamplesGenerator;
import io.improbable.keanu.algorithms.mcmc.ProposalRejectionStrategy;
import io.improbable.keanu.algorithms.mcmc.RollBackToCachedValuesOnRejection;
import io.improbable.keanu.algorithms.mcmc.SamplingAlgorithm;
import io.improbable.keanu.algorithms.mcmc.proposal.MHStepVariableSelector;
import io.improbable.keanu.algorithms.mcmc.proposal.PriorProposalDistribution;
import io.improbable.keanu.algorithms.mcmc.proposal.ProposalDistribution;
import io.improbable.keanu.util.status.StatusBar;
import java.util.List;
import lombok.NonNull;

public class MetropolisHastings
implements PosteriorSamplingAlgorithm {
    private static final MHStepVariableSelector DEFAULT_VARIABLE_SELECTOR = MHStepVariableSelector.SINGLE_VARIABLE_SELECTOR;
    private final KeanuRandom random;
    @NonNull
    private final ProposalDistribution proposalDistribution;
    private final MHStepVariableSelector variableSelector;
    @NonNull
    private final ProposalRejectionStrategy rejectionStrategy;

    public static MetropolisHastingsBuilder builder() {
        return new MetropolisHastingsBuilder();
    }

    @Override
    public NetworkSamples getPosteriorSamples(ProbabilisticModel model, List<? extends Variable> variablesToSampleFrom, int sampleCount) {
        return this.generatePosteriorSamples(model, variablesToSampleFrom).generate(sampleCount);
    }

    @Override
    public NetworkSamplesGenerator generatePosteriorSamples(ProbabilisticModel model, List<? extends Variable> variablesToSampleFrom) {
        return new NetworkSamplesGenerator(this.setupSampler(model, variablesToSampleFrom), StatusBar::new);
    }

    private SamplingAlgorithm setupSampler(ProbabilisticModel model, List<? extends Variable> variablesToSampleFrom) {
        MetropolisHastingsStep mhStep = new MetropolisHastingsStep(model, this.proposalDistribution, this.rejectionStrategy, this.random);
        return new MetropolisHastingsSampler(model.getLatentVariables(), variablesToSampleFrom, mhStep, this.variableSelector, model.logProb());
    }

    private MetropolisHastings(KeanuRandom random, @NonNull ProposalDistribution proposalDistribution, MHStepVariableSelector variableSelector, @NonNull ProposalRejectionStrategy rejectionStrategy) {
        if (proposalDistribution == null) {
            throw new NullPointerException("proposalDistribution");
        }
        if (rejectionStrategy == null) {
            throw new NullPointerException("rejectionStrategy");
        }
        this.random = random;
        this.proposalDistribution = proposalDistribution;
        this.variableSelector = variableSelector;
        this.rejectionStrategy = rejectionStrategy;
    }

    public KeanuRandom getRandom() {
        return this.random;
    }

    @NonNull
    public ProposalDistribution getProposalDistribution() {
        return this.proposalDistribution;
    }

    public MHStepVariableSelector getVariableSelector() {
        return this.variableSelector;
    }

    @NonNull
    public ProposalRejectionStrategy getRejectionStrategy() {
        return this.rejectionStrategy;
    }

    static /* synthetic */ MHStepVariableSelector access$000() {
        return DEFAULT_VARIABLE_SELECTOR;
    }

    public static class MetropolisHastingsBuilder {
        private KeanuRandom random = KeanuRandom.getDefaultRandom();
        private ProposalDistribution proposalDistribution = new PriorProposalDistribution();
        private MHStepVariableSelector variableSelector = MetropolisHastings.access$000();
        private ProposalRejectionStrategy rejectionStrategy = new RollBackToCachedValuesOnRejection();

        public MetropolisHastingsBuilder random(KeanuRandom random) {
            this.random = random;
            return this;
        }

        public MetropolisHastingsBuilder proposalDistribution(ProposalDistribution proposalDistribution) {
            this.proposalDistribution = proposalDistribution;
            return this;
        }

        public MetropolisHastingsBuilder variableSelector(MHStepVariableSelector variableSelector) {
            this.variableSelector = variableSelector;
            return this;
        }

        public MetropolisHastingsBuilder rejectionStrategy(ProposalRejectionStrategy rejectionStrategy) {
            this.rejectionStrategy = rejectionStrategy;
            return this;
        }

        public MetropolisHastings build() {
            return new MetropolisHastings(this.random, this.proposalDistribution, this.variableSelector, this.rejectionStrategy);
        }

        public String toString() {
            return "MetropolisHastings.MetropolisHastingsBuilder(random=" + this.random + ", proposalDistribution=" + this.proposalDistribution + ", variableSelector=" + this.variableSelector + ", rejectionStrategy=" + this.rejectionStrategy + ")";
        }
    }
}

