/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.graphtraversal;

import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.Probabilistic;
import io.improbable.keanu.vertices.Vertex;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;

public class VertexValuePropagation {
    private VertexValuePropagation() {
    }

    public static void cascadeUpdate(Vertex ... cascadeFrom) {
        VertexValuePropagation.cascadeUpdate(Arrays.asList(cascadeFrom));
    }

    public static void cascadeUpdate(Vertex vertex) {
        VertexValuePropagation.cascadeUpdate(Collections.singletonList(vertex));
    }

    public static void cascadeUpdate(Collection<? extends Vertex> cascadeFrom) {
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>(Comparator.comparing(Vertex::getId, Comparator.naturalOrder()));
        priorityQueue.addAll(cascadeFrom);
        HashSet<? extends Vertex> alreadyQueued = new HashSet<Vertex>(cascadeFrom);
        while (!priorityQueue.isEmpty()) {
            Vertex visiting = priorityQueue.poll();
            VertexValuePropagation.updateVertexValue(visiting);
            for (Vertex child : visiting.getChildren()) {
                if (child.isProbabilistic() || alreadyQueued.contains(child)) continue;
                priorityQueue.offer(child);
                alreadyQueued.add(child);
            }
        }
    }

    public static void eval(Vertex ... vertices) {
        VertexValuePropagation.eval(Arrays.asList(vertices));
    }

    public static void eval(Collection<? extends Vertex> vertices) {
        Deque<Vertex> stack = VertexValuePropagation.asDeque(vertices);
        HashSet hasCalculated = new HashSet();
        while (!stack.isEmpty()) {
            Vertex head = stack.peek();
            Set<Vertex<?>> parentsThatAreNotYetCalculated = VertexValuePropagation.parentsThatAreNotCalculated(hasCalculated, head.getParents());
            if (head.isProbabilistic() || parentsThatAreNotYetCalculated.isEmpty()) {
                Vertex top = stack.pop();
                VertexValuePropagation.updateVertexValue(top);
                hasCalculated.add(top);
                continue;
            }
            for (Vertex<?> vertex : parentsThatAreNotYetCalculated) {
                stack.push(vertex);
            }
        }
    }

    private static Set<Vertex<?>> parentsThatAreNotCalculated(Set<Vertex<?>> calculated, Collection<Vertex> parents) {
        HashSet notCalculatedParents = new HashSet();
        for (Vertex next : parents) {
            if (calculated.contains(next)) continue;
            notCalculatedParents.add(next);
        }
        return notCalculatedParents;
    }

    public static void lazyEval(Vertex ... vertices) {
        VertexValuePropagation.lazyEval(Arrays.asList(vertices));
    }

    public static void lazyEval(Collection<? extends Vertex> vertices) {
        Deque<Vertex> stack = VertexValuePropagation.asDeque(vertices);
        while (!stack.isEmpty()) {
            Vertex head = stack.peek();
            Set<Vertex<?>> parentsThatAreNotYetCalculated = VertexValuePropagation.parentsThatAreNotCalculated(head.getParents());
            if (head.isProbabilistic() || parentsThatAreNotYetCalculated.isEmpty()) {
                Vertex top = stack.pop();
                VertexValuePropagation.updateVertexValue(top);
                continue;
            }
            for (Vertex<?> vertex : parentsThatAreNotYetCalculated) {
                stack.push(vertex);
            }
        }
    }

    private static Set<Vertex<?>> parentsThatAreNotCalculated(Collection<Vertex> parents) {
        HashSet notCalculatedParents = new HashSet();
        for (Vertex next : parents) {
            if (next.hasValue()) continue;
            notCalculatedParents.add(next);
        }
        return notCalculatedParents;
    }

    private static Deque<Vertex> asDeque(Iterable<? extends Vertex> vertices) {
        ArrayDeque<Vertex> stack = new ArrayDeque<Vertex>();
        for (Vertex vertex : vertices) {
            stack.push(vertex);
        }
        return stack;
    }

    private static <T> void updateVertexValue(Vertex<T> vertex) {
        if (vertex.isProbabilistic()) {
            if (!vertex.hasValue()) {
                vertex.setValue(((Probabilistic)((Object)vertex)).sample());
            }
        } else if (!vertex.isObserved()) {
            vertex.setValue(((NonProbabilistic)((Object)vertex)).calculate());
        }
    }
}

