/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.graphtraversal;

import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TopologicalSort {
    private TopologicalSort() {
    }

    public static List<Vertex> sort(Collection<? extends Vertex> vertices) {
        return vertices.stream().sorted(Comparator.comparing(Vertex::getId, Comparator.naturalOrder())).collect(Collectors.toList());
    }

    public static Map<Vertex, Set<Vertex>> mapDependencies(Collection<? extends Vertex> vertices) {
        HashMap<Vertex, Set<Vertex>> deps = new HashMap<Vertex, Set<Vertex>>();
        HashSet<Vertex> verticesBeingSorted = new HashSet<Vertex>(vertices);
        for (Vertex vertex : vertices) {
            if (deps.containsKey(vertex)) continue;
            TopologicalSort.insertParentDependencies(vertex, deps, verticesBeingSorted);
        }
        return deps;
    }

    private static void insertParentDependencies(Vertex<?> aVertex, Map<Vertex, Set<Vertex>> dependencies, Set<Vertex> verticesToCount) {
        dependencies.computeIfAbsent(aVertex, v -> new HashSet());
        aVertex.getParents().forEach(parent -> {
            if (!dependencies.containsKey(parent)) {
                TopologicalSort.insertParentDependencies(parent, dependencies, verticesToCount);
            }
            Set parentDependencies = (Set)dependencies.get(parent);
            dependencies.computeIfPresent(aVertex, (vertex, vertexDependencies) -> {
                vertexDependencies.addAll(parentDependencies);
                if (verticesToCount.contains(parent)) {
                    vertexDependencies.add(parent);
                }
                return vertexDependencies;
            });
        });
    }
}

