/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.graphtraversal;

import io.improbable.keanu.network.LambdaSection;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MarkovBlanket {
    private MarkovBlanket() {
    }

    public static Set<Vertex> get(Vertex<?> aVertex) {
        LambdaSection parents = LambdaSection.getUpstreamLambdaSection(aVertex, false);
        LambdaSection children = LambdaSection.getDownstreamLambdaSection(aVertex, false);
        Set<Vertex> childrensParents = MarkovBlanket.getUpstreamProbabilisticVertices(children.getLatentAndObservedVertices());
        HashSet<Vertex> blanket = new HashSet<Vertex>();
        blanket.addAll(parents.getLatentAndObservedVertices());
        blanket.addAll(children.getLatentAndObservedVertices());
        blanket.addAll(childrensParents);
        blanket.remove(aVertex);
        return blanket;
    }

    private static Set<Vertex> getUpstreamProbabilisticVertices(Collection<Vertex> vertices) {
        HashSet<Vertex> probabilistic = new HashSet<Vertex>();
        for (Vertex vertex : vertices) {
            LambdaSection upstreamLambdaSection = LambdaSection.getUpstreamLambdaSection(vertex, false);
            probabilistic.addAll(upstreamLambdaSection.getLatentAndObservedVertices());
        }
        return probabilistic;
    }
}

