/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.graphtraversal;

import io.improbable.keanu.vertices.Vertex;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public class DiscoverGraph {
    private DiscoverGraph() {
    }

    public static Set<Vertex> getEntireGraph(Vertex<?> initialVertex) {
        HashSet<Vertex> discoveredGraph = new HashSet<Vertex>();
        ArrayDeque<Vertex> stack = new ArrayDeque<Vertex>();
        discoveredGraph.add(initialVertex);
        stack.addFirst(initialVertex);
        while (!stack.isEmpty()) {
            Vertex visiting = (Vertex)stack.removeFirst();
            for (Vertex child : visiting.getChildren()) {
                if (discoveredGraph.contains(child)) continue;
                stack.addFirst(child);
                discoveredGraph.add(child);
            }
            for (Vertex parent : visiting.getParents()) {
                if (discoveredGraph.contains(parent)) continue;
                stack.addFirst(parent);
                discoveredGraph.add(parent);
            }
        }
        return discoveredGraph;
    }
}

