/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms.graphtraversal;

import io.improbable.keanu.vertices.Vertex;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class BreadthFirstSearch {
    public static boolean bfsWithFailureCondition(Collection<Vertex> vertices, Predicate<Vertex> failureCondition, Function<Vertex, Collection<Vertex>> nextVertices, Consumer<Collection<Vertex>> successfullyVisitedConsumer) {
        ArrayDeque<Vertex> queue = new ArrayDeque<Vertex>(vertices);
        HashSet<Vertex> visited = new HashSet<Vertex>(vertices);
        while (!queue.isEmpty()) {
            Vertex visiting = (Vertex)queue.poll();
            if (failureCondition.test(visiting)) {
                return false;
            }
            BreadthFirstSearch.queueUnvisitedNextVertices(nextVertices.apply(visiting), queue, visited);
        }
        successfullyVisitedConsumer.accept(visited);
        return true;
    }

    private static void queueUnvisitedNextVertices(Collection<Vertex> nextVertices, Queue<Vertex> queue, Set<Vertex> visited) {
        for (Vertex next : nextVertices) {
            if (visited.contains(next)) continue;
            queue.offer(next);
            visited.add(next);
        }
    }

    public static <T> void doNothing(T toConsume) {
    }
}

