/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statistics {
    private Map<Enum, List<Double>> statistics = new HashMap<Enum, List<Double>>();

    public Statistics(Enum[] keys) {
        this.initialise(keys);
    }

    public void store(Enum key, Double value) {
        List<Double> values = this.statistics.get(key);
        values.add(value);
    }

    public List<Double> get(Enum key) {
        return this.statistics.get(key);
    }

    public Set<Enum> keys() {
        return this.statistics.keySet();
    }

    public double average(Enum key) {
        return this.statistics.get(key).stream().mapToDouble(x -> x).average().orElse(Double.NaN);
    }

    private void initialise(Enum[] keys) {
        for (Enum key : keys) {
            this.statistics.put(key, new ArrayList());
        }
    }
}

