/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Samples<T> {
    protected final List<T> samples;

    public Samples(List<T> samples) {
        Preconditions.checkArgument((!samples.isEmpty() ? 1 : 0) != 0, (Object)"No samples provided.");
        this.samples = samples;
    }

    public double probability(Function<T, Boolean> samplePredicate) {
        long trueCount = this.samples.parallelStream().filter(samplePredicate::apply).count();
        return (double)trueCount / (double)this.samples.size();
    }

    public T getMode() {
        if (this.samples.isEmpty()) {
            throw new IllegalStateException("Mode for empty samples is undefined");
        }
        Map<Object, List<Object>> groupedByValue = this.samples.stream().collect(Collectors.groupingBy(v -> v));
        Optional<Object> mode = groupedByValue.entrySet().stream().sorted(Comparator.comparing(v -> -((List)v.getValue()).size())).map(Map.Entry::getKey).findFirst();
        if (mode.isPresent()) {
            return (T)mode.get();
        }
        throw new IllegalStateException("Mode is undefined");
    }

    public List<T> asList() {
        return new ArrayList<T>(this.samples);
    }

    public T asTensor() {
        throw new UnsupportedOperationException("Generic samples cannot be coerced into a tensor.");
    }
}

