/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.algorithms;

import io.improbable.keanu.algorithms.Variable;
import io.improbable.keanu.algorithms.VariableReference;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface ProbabilisticModel
extends AutoCloseable {
    default public double logProb() {
        return this.logProb(Collections.emptyMap());
    }

    public double logProb(Map<VariableReference, ?> var1);

    default public double logLikelihood() {
        return this.logLikelihood(Collections.emptyMap());
    }

    public double logLikelihood(Map<VariableReference, ?> var1);

    public List<Variable> getLatentVariables();

    default public List<? extends Variable<DoubleTensor, ?>> getContinuousLatentVariables() {
        return this.getLatentVariables().stream().filter(v -> v.getValue() instanceof DoubleTensor).map(v -> v).collect(Collectors.toList());
    }

    default public double logProbAfter(Map<VariableReference, Object> newValues, double logProbBefore) {
        return this.logProb(newValues);
    }

    @Override
    default public void close() {
    }
}

