/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu;

import io.improbable.keanu.distributions.continuous.Gamma;
import io.improbable.keanu.distributions.continuous.Laplace;
import io.improbable.keanu.distributions.discrete.Poisson;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;

public class KeanuRandom {
    private static final AtomicReference<KeanuRandom> DEFAULT_RANDOM = new AtomicReference();
    private final RandomGenerator random;

    public static KeanuRandom getDefaultRandom() {
        return DEFAULT_RANDOM.get();
    }

    public static void setDefaultRandomSeed(long seed) {
        DEFAULT_RANDOM.set(new KeanuRandom(seed));
    }

    public KeanuRandom() {
        this(System.currentTimeMillis());
    }

    public KeanuRandom(long seed) {
        this.random = new SynchronizedRandomGenerator((RandomGenerator)new MersenneTwister(seed));
    }

    public DoubleTensor nextDouble(long[] shape) {
        int length = TensorShape.getLengthAsInt(shape);
        if (length > 1) {
            return DoubleTensor.create(this.nextDoubleBuffer(length), shape);
        }
        return DoubleTensor.create(this.nextDouble(), shape);
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextDouble(double min, double max) {
        return this.random.nextDouble() * (max - min) + min;
    }

    public double nextDoubleNonZero() {
        double randomValue;
        while ((randomValue = this.nextDouble()) == 0.0) {
        }
        return randomValue;
    }

    public DoubleTensor nextGaussian(long[] shape) {
        int length = TensorShape.getLengthAsInt(shape);
        if (length > 1) {
            return DoubleTensor.create(this.nextGaussianBuffer(length), shape);
        }
        return DoubleTensor.create(this.nextGaussian(), shape);
    }

    public DoubleTensor nextGaussian(long[] shape, DoubleTensor mu, DoubleTensor sigma) {
        return this.nextGaussian(shape).timesInPlace(sigma).plusInPlace(mu);
    }

    public DoubleTensor nextGamma(long[] shape, DoubleTensor theta, DoubleTensor k) {
        return (DoubleTensor)Gamma.withParameters(theta, k).sample(shape, this);
    }

    public DoubleTensor nextLaplace(long[] shape, DoubleTensor mu, DoubleTensor beta) {
        return (DoubleTensor)Laplace.withParameters(mu, beta).sample(shape, this);
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }

    public double nextGaussian(double mu, double sigma) {
        return this.random.nextGaussian() * sigma + mu;
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public IntegerTensor nextInt(long[] shape) {
        int length = TensorShape.getLengthAsInt(shape);
        if (length > 1) {
            return IntegerTensor.create(this.nextIntBuffer(length), shape);
        }
        return IntegerTensor.create(this.nextInt(), shape);
    }

    public IntegerTensor nextPoisson(long[] shape, DoubleTensor mu) {
        return (IntegerTensor)Poisson.withParameters(mu).sample(shape, this);
    }

    public int nextInt(int maxExclusive) {
        return this.random.nextInt(maxExclusive);
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    private int[] nextIntBuffer(int length) {
        int[] buffer = new int[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.nextInt();
        }
        return buffer;
    }

    private double[] nextDoubleBuffer(int length) {
        double[] buffer = new double[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.nextDouble();
        }
        return buffer;
    }

    private double[] nextGaussianBuffer(int length) {
        double[] buffer = new double[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.nextGaussian();
        }
        return buffer;
    }

    static {
        String randomSeed = System.getProperty("io.improbable.keanu.defaultRandom.seed");
        if (randomSeed != null) {
            long seed = Long.parseLong(randomSeed);
            DEFAULT_RANDOM.set(new KeanuRandom(seed));
        } else {
            DEFAULT_RANDOM.set(new KeanuRandom());
        }
    }
}

