/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.algorithms.PosteriorSamplingAlgorithm;
import io.improbable.keanu.algorithms.graphtraversal.DifferentiableChecker;
import io.improbable.keanu.algorithms.mcmc.MetropolisHastings;
import io.improbable.keanu.algorithms.mcmc.RollBackToCachedValuesOnRejection;
import io.improbable.keanu.algorithms.mcmc.SimulatedAnnealing;
import io.improbable.keanu.algorithms.mcmc.nuts.NUTS;
import io.improbable.keanu.algorithms.mcmc.proposal.PriorProposalDistribution;
import io.improbable.keanu.algorithms.sampling.Forward;
import io.improbable.keanu.algorithms.variational.optimizer.gradient.GradientOptimizer;
import io.improbable.keanu.algorithms.variational.optimizer.nongradient.NonGradientOptimizer;
import io.improbable.keanu.network.BayesianNetwork;
import io.improbable.keanu.network.KeanuProbabilisticModel;
import io.improbable.keanu.network.KeanuProbabilisticModelWithGradient;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class Keanu {
    private Keanu() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Optimizer {
        public static io.improbable.keanu.algorithms.variational.optimizer.Optimizer of(Collection<? extends Vertex> vertices) {
            return Optimizer.of(new BayesianNetwork(vertices));
        }

        public static io.improbable.keanu.algorithms.variational.optimizer.Optimizer of(BayesianNetwork network) {
            if (DifferentiableChecker.isDifferentiableWrtLatents(network.getLatentOrObservedVertices())) {
                return Gradient.of(network);
            }
            return NonGradient.of(network);
        }

        public static io.improbable.keanu.algorithms.variational.optimizer.Optimizer ofConnectedGraph(Vertex<?> vertexFromNetwork) {
            return Optimizer.of(vertexFromNetwork.getConnectedGraph());
        }

        static void initializeNetworkForOptimization(BayesianNetwork bayesianNetwork) {
            boolean containsDiscreteLatents;
            List<Vertex> discreteLatentVertices = bayesianNetwork.getDiscreteLatentVertices();
            boolean bl = containsDiscreteLatents = !discreteLatentVertices.isEmpty();
            if (containsDiscreteLatents) {
                throw new UnsupportedOperationException("Optimization unsupported on networks containing discrete latents. Found " + discreteLatentVertices.size() + " discrete latents.");
            }
            bayesianNetwork.cascadeObservations();
        }

        private Optimizer() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static final class Gradient {
            public static GradientOptimizer of(BayesianNetwork bayesNet) {
                return Gradient.builderFor(bayesNet).build();
            }

            public static GradientOptimizer of(Collection<? extends Vertex> vertices) {
                return Gradient.of(new BayesianNetwork(vertices));
            }

            public static GradientOptimizer ofConnectedGraph(Vertex<?> vertexFromNetwork) {
                return Gradient.of(vertexFromNetwork.getConnectedGraph());
            }

            public static GradientOptimizer.GradientOptimizerBuilder builderFor(Set<Vertex> connectedGraph) {
                return Gradient.builderFor(new BayesianNetwork(connectedGraph));
            }

            public static GradientOptimizer.GradientOptimizerBuilder builderFor(BayesianNetwork network) {
                Optimizer.initializeNetworkForOptimization(network);
                return GradientOptimizer.builder().probabilisticModel(new KeanuProbabilisticModelWithGradient(network));
            }

            private Gradient() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static final class NonGradient {
            public static NonGradientOptimizer of(BayesianNetwork bayesNet) {
                bayesNet.cascadeObservations();
                return NonGradient.builderFor(bayesNet).build();
            }

            public static NonGradientOptimizer of(Collection<? extends Vertex> vertices) {
                return NonGradient.of(new BayesianNetwork(vertices));
            }

            public static NonGradientOptimizer ofConnectedGraph(Vertex<?> vertexFromNetwork) {
                return NonGradient.of(vertexFromNetwork.getConnectedGraph());
            }

            public static NonGradientOptimizer.NonGradientOptimizerBuilder builderFor(Collection<? extends Vertex> vertices) {
                return NonGradient.builderFor(new BayesianNetwork(vertices));
            }

            public static NonGradientOptimizer.NonGradientOptimizerBuilder builderFor(BayesianNetwork network) {
                Optimizer.initializeNetworkForOptimization(network);
                return NonGradientOptimizer.builder().probabilisticModel(new KeanuProbabilisticModel(network));
            }

            private NonGradient() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }
    }

    public static final class Sampling {
        private Sampling() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static final class SimulatedAnnealing {
            public static io.improbable.keanu.algorithms.mcmc.SimulatedAnnealing withDefaultConfig() {
                return SimulatedAnnealing.withDefaultConfig(KeanuRandom.getDefaultRandom());
            }

            public static io.improbable.keanu.algorithms.mcmc.SimulatedAnnealing withDefaultConfig(KeanuRandom random) {
                return SimulatedAnnealing.builder().proposalDistribution(new PriorProposalDistribution()).rejectionStrategy(new RollBackToCachedValuesOnRejection()).random(random).build();
            }

            public static SimulatedAnnealing.SimulatedAnnealingBuilder builder() {
                return io.improbable.keanu.algorithms.mcmc.SimulatedAnnealing.builder();
            }

            private SimulatedAnnealing() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static final class Forward {
            public static io.improbable.keanu.algorithms.sampling.Forward withDefaultConfig() {
                return new io.improbable.keanu.algorithms.sampling.Forward(KeanuRandom.getDefaultRandom(), false);
            }

            public static io.improbable.keanu.algorithms.sampling.Forward withDefaultConfig(KeanuRandom random) {
                return new io.improbable.keanu.algorithms.sampling.Forward(random, false);
            }

            public static Forward.ForwardBuilder builder() {
                return io.improbable.keanu.algorithms.sampling.Forward.builder();
            }

            private Forward() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static final class NUTS {
            public static io.improbable.keanu.algorithms.mcmc.nuts.NUTS withDefaultConfig() {
                return NUTS.withDefaultConfig(KeanuRandom.getDefaultRandom());
            }

            public static io.improbable.keanu.algorithms.mcmc.nuts.NUTS withDefaultConfig(KeanuRandom random) {
                return NUTS.builder().random(random).build();
            }

            public static NUTS.NUTSBuilder builder() {
                return io.improbable.keanu.algorithms.mcmc.nuts.NUTS.builder();
            }

            private NUTS() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static final class MetropolisHastings {
            public static io.improbable.keanu.algorithms.mcmc.MetropolisHastings withDefaultConfig() {
                return MetropolisHastings.withDefaultConfig(KeanuRandom.getDefaultRandom());
            }

            public static io.improbable.keanu.algorithms.mcmc.MetropolisHastings withDefaultConfig(KeanuRandom random) {
                return MetropolisHastings.builder().proposalDistribution(new PriorProposalDistribution()).rejectionStrategy(new RollBackToCachedValuesOnRejection()).random(random).build();
            }

            public static MetropolisHastings.MetropolisHastingsBuilder builder() {
                return io.improbable.keanu.algorithms.mcmc.MetropolisHastings.builder();
            }

            private MetropolisHastings() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static final class MCMC {
            public static PosteriorSamplingAlgorithm withDefaultConfigFor(KeanuProbabilisticModel model) {
                return MCMC.withDefaultConfigFor(model, KeanuRandom.getDefaultRandom());
            }

            public static PosteriorSamplingAlgorithm withDefaultConfigFor(KeanuProbabilisticModel model, KeanuRandom random) {
                if (DifferentiableChecker.isDifferentiableWrtLatents(model.getLatentOrObservedVertices())) {
                    return NUTS.withDefaultConfig(random);
                }
                return MetropolisHastings.withDefaultConfig(random);
            }

            private MCMC() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }
    }
}

