/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.hyphenate.util.DocumentFile;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.FileUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.VersionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class UriUtils {
    private static final String TAG = UriUtils.class.getSimpleName();

    public static boolean isFileExistByUri(Context context, Uri fileUri) {
        if (fileUri == null) {
            return false;
        }
        boolean bl = DocumentFile.isDocumentUri(context, fileUri);
        if (bl) {
            return DocumentFile.fromSingleUri(context, fileUri).exists();
        }
        String string = UriUtils.getFilePath(context, fileUri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return new File(string).exists();
        }
        if (UriUtils.uriStartWithFile(fileUri)) {
            String string2 = fileUri.getPath();
            boolean bl2 = new File(string2).exists();
            long l = new File(string2).length();
            EMLog.d(TAG, "file uri exist = " + bl2 + " file length = " + l);
            return bl2;
        }
        if (!UriUtils.uriStartWithContent(fileUri)) {
            return fileUri.toString().startsWith("/") && new File(fileUri.toString()).exists();
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri(context, fileUri);
        return documentFile != null && documentFile.exists();
    }

    public static boolean uriStartWithFile(Uri fileUri) {
        return "file".equalsIgnoreCase(fileUri.getScheme()) && fileUri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri fileUri) {
        return "content".equalsIgnoreCase(fileUri.getScheme());
    }

    public static String getFileNameByUri(Context context, Uri fileUri) {
        if (context == null || fileUri == null) {
            return "";
        }
        String string = context.getContentResolver().getType(fileUri);
        String string2 = null;
        if (string == null) {
            String string3 = UriUtils.getFilePath(context, fileUri);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                string2 = UriUtils.getName(fileUri.toString());
            } else {
                File file = new File(string3);
                string2 = file.getName();
            }
        } else {
            Cursor cursor = context.getContentResolver().query(fileUri, null, null, null, null);
            if (cursor != null) {
                int n = cursor.getColumnIndex("_display_name");
                cursor.moveToFirst();
                string2 = cursor.getString(n);
                cursor.close();
            }
        }
        EMLog.d(TAG, "getFileNameByUri filename: " + string2);
        return string2;
    }

    private static String getName(String filePath) {
        if (filePath == null) {
            return null;
        }
        int n = filePath.lastIndexOf(47);
        return filePath.substring(n + 1);
    }

    @Deprecated
    public static String getFilenameByDocument(Context context, Uri uri) {
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return "";
        }
        return documentFile.getName();
    }

    public static long getFileLength(Context context, Uri fileUri) {
        boolean bl = DocumentFile.isDocumentUri(context, fileUri);
        if (bl) {
            return DocumentFile.fromSingleUri(context, fileUri).length();
        }
        String string = context.getContentResolver().getType(fileUri);
        long l = 0L;
        if (string == null && context != null) {
            String string2 = UriUtils.getFilePath(context, fileUri);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                l = new File(string2).length();
            }
        } else {
            Cursor cursor = context.getContentResolver().query(fileUri, null, null, null, null);
            if (cursor != null) {
                int n = cursor.getColumnIndex("_size");
                cursor.moveToFirst();
                l = cursor.getLong(n);
                cursor.close();
            }
        }
        EMLog.d(TAG, "getFileLength fileSize: " + l);
        return l;
    }

    @Deprecated
    public static String getFileMimeType(Context context, Uri fileUri) {
        if (fileUri == null) {
            return null;
        }
        if (!VersionUtils.isTargetQ(context)) {
            String string = UriUtils.getFilePath(context, fileUri);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return FileUtils.getMIMEType(new File(string));
            }
            return null;
        }
        if (UriUtils.uriStartWithFile(fileUri)) {
            return FileUtils.getMIMEType(new File(fileUri.getPath()));
        }
        if (!UriUtils.uriStartWithContent(fileUri)) {
            if (fileUri.toString().startsWith("/") && new File(fileUri.toString()).exists()) {
                return FileUtils.getMIMEType(new File(fileUri.toString()));
            }
            return null;
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, fileUri);
        if (documentFile == null) {
            return null;
        }
        return documentFile.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVideoOrAudioDuration(Context context, Uri mediaUri) {
        String[] stringArray = new String[]{"duration"};
        Cursor cursor = context.getContentResolver().query(mediaUri, stringArray, null, null, null);
        long l = 0L;
        if (cursor != null && cursor.moveToFirst()) {
            l = cursor.getLong(cursor.getColumnIndex("duration"));
            cursor.close();
            cursor = null;
        }
        if (l <= 0L) {
            MediaMetadataRetriever mediaMetadataRetriever = null;
            String string = "";
            try {
                mediaMetadataRetriever = new MediaMetadataRetriever();
                mediaMetadataRetriever.setDataSource(context, mediaUri);
                string = mediaMetadataRetriever.extractMetadata(9);
                l = Integer.valueOf(string).intValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            finally {
                if (mediaMetadataRetriever != null) {
                    try {
                        mediaMetadataRetriever.release();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        if (l <= 0L) {
            l = 0L;
        }
        EMLog.d(TAG, "duration:" + l);
        return (int)l;
    }

    private static DocumentFile getDocumentFile(Context context, Uri uri) {
        if (uri == null) {
            EMLog.e(TAG, "uri is null");
            return null;
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri(context, uri);
        if (documentFile == null) {
            EMLog.e(TAG, "DocumentFile is null");
            return null;
        }
        return documentFile;
    }

    public static String getUriString(Uri uri) {
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    @Deprecated
    public static Uri getLocalUriFromString(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (url.startsWith("content")) {
            return Uri.parse((String)url);
        }
        if (url.startsWith("file") && url.length() > 7) {
            return Uri.fromFile((File)new File(Uri.parse((String)url).getPath()));
        }
        if (url.startsWith("/")) {
            return Uri.fromFile((File)new File(url));
        }
        return null;
    }

    public static String getMimeType(Context context, Uri fileUri) {
        String string;
        String string2 = context.getContentResolver().getType(fileUri);
        if (TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string = UriUtils.getFilePath(context, fileUri)))) {
            string2 = UriUtils.getMimeType(new File(string));
        }
        EMLog.d(TAG, "getMimeType mimeType: " + string2);
        return string2;
    }

    public static String getMimeType(File sourceFile) {
        return FileUtils.getMIMEType(sourceFile);
    }

    public static String getMimeType(String fileName) {
        if (fileName.endsWith(".3gp") || fileName.endsWith(".amr")) {
            return "audio/3gp";
        }
        if (fileName.endsWith(".jpe") || fileName.endsWith(".jpeg") || fileName.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".amr")) {
            return "audio/amr";
        }
        if (fileName.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (fileName.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        return "application/octet-stream";
    }

    public static String getFilePath(Context context, String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        return UriUtils.getFilePath(context, Uri.parse((String)path));
    }

    public static String getFilePath(Context context, Uri uri) {
        if (uri == null) {
            return "";
        }
        if (!VersionUtils.isTargetQ(context)) {
            boolean bl;
            boolean bl2 = bl = Build.VERSION.SDK_INT >= 19;
            if (bl && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
                if (UriUtils.isExternalStorageDocument(uri)) {
                    String string = DocumentsContract.getDocumentId((Uri)uri);
                    String[] stringArray = string.split(":");
                    String string2 = stringArray[0];
                    if ("primary".equalsIgnoreCase(string2)) {
                        return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    }
                } else {
                    if (UriUtils.isDownloadsDocument(uri)) {
                        String string = DocumentsContract.getDocumentId((Uri)uri);
                        if (string.startsWith("raw:")) {
                            return string.replaceFirst("raw:", "");
                        }
                        String[] stringArray = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads", "content://downloads/all_downloads"};
                        if (Build.VERSION.SDK_INT < 26) {
                            for (String string3 : stringArray) {
                                Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)string3), (long)Long.valueOf(string));
                                String string4 = null;
                                try {
                                    string4 = UriUtils.getDataColumn(context, uri2, null, null);
                                    if (TextUtils.isEmpty((CharSequence)string4)) continue;
                                    return string4;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return "";
                        }
                        String string5 = null;
                        try {
                            string5 = UriUtils.getDataColumn(context, uri, null, null);
                            if (!TextUtils.isEmpty((CharSequence)string5)) {
                                return string5;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return "";
                    }
                    if (UriUtils.isMediaDocument(uri)) {
                        String string = DocumentsContract.getDocumentId((Uri)uri);
                        String[] stringArray = string.split(":");
                        String string6 = stringArray[0];
                        Uri uri3 = null;
                        if ("image".equals(string6)) {
                            uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(string6)) {
                            uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(string6)) {
                            uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String string7 = "_id=?";
                        String[] stringArray2 = new String[]{stringArray[1]};
                        String string8 = null;
                        try {
                            string8 = UriUtils.getDataColumn(context, uri3, "_id=?", stringArray2);
                            if (!TextUtils.isEmpty((CharSequence)string8)) {
                                return string8;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return "";
                    }
                }
            } else {
                if (UriUtils.isFileProvider(context, uri)) {
                    return UriUtils.getFPUriToPath(context, uri);
                }
                if (UriUtils.isOtherFileProvider(context, uri)) {
                    return UriUtils.copyFileProviderUri(context, uri);
                }
                if (UriUtils.uriStartWithContent(uri)) {
                    String string = null;
                    try {
                        string = UriUtils.getDataColumn(context, uri, null, null);
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            return string;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "";
                }
            }
        }
        if (UriUtils.isFileProvider(context, uri)) {
            return UriUtils.getFPUriToPath(context, uri);
        }
        if (UriUtils.isOtherFileProvider(context, uri)) {
            return UriUtils.copyFileProviderUri(context, uri);
        }
        if (UriUtils.uriStartWithFile(uri)) {
            return uri.getPath();
        }
        if (uri.toString().startsWith("/")) {
            return uri.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyFileProviderUri(Context context, Uri uri) {
        String string = UriUtils.getFileNameByUri(context, uri);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = PathUtil.getInstance().getFilePath() + File.separator + string;
        if (new File(string2).exists()) {
            return string2;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = context.getContentResolver().openInputStream(uri);
            outputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new File(string2).exists() ? string2 : "";
    }

    private static String getFPUriToPath(Context context, Uri uri) {
        try {
            List list = context.getPackageManager().getInstalledPackages(8);
            if (list != null) {
                String string = FileProvider.class.getName();
                block7: for (PackageInfo packageInfo : list) {
                    ProviderInfo[] providerInfoArray = packageInfo.providers;
                    if (providerInfoArray == null) continue;
                    for (ProviderInfo providerInfo : providerInfoArray) {
                        if (!uri.getAuthority().equals(providerInfo.authority)) continue;
                        if (!providerInfo.name.equalsIgnoreCase(string)) continue block7;
                        Class<FileProvider> clazz = FileProvider.class;
                        try {
                            Method method = clazz.getDeclaredMethod("getPathStrategy", Context.class, String.class);
                            method.setAccessible(true);
                            Object object = method.invoke(null, context, uri.getAuthority());
                            if (object == null) continue block7;
                            String string2 = FileProvider.class.getName() + "$PathStrategy";
                            Class<?> clazz2 = Class.forName(string2);
                            Method method2 = clazz2.getDeclaredMethod("getFileForUri", Uri.class);
                            method2.setAccessible(true);
                            Object object2 = method2.invoke(object, uri);
                            if (!(object2 instanceof File)) continue block7;
                            String string3 = ((File)object2).getAbsolutePath();
                            return string3;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            noSuchMethodException.printStackTrace();
                            continue block7;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                            continue block7;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            continue block7;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            classNotFoundException.printStackTrace();
                            continue block7;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String string = "_data";
        String[] stringArray = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, stringArray, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(n);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isFileProvider(Context context, Uri uri) {
        return (context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority());
    }

    public static boolean isOtherFileProvider(Context context, Uri uri) {
        String string = uri.getScheme();
        String string2 = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return !(context.getApplicationInfo().packageName + ".fileProvider").equalsIgnoreCase(uri.getAuthority()) && "content".equalsIgnoreCase(uri.getScheme()) && string2.contains(".fileProvider".toLowerCase());
    }
}

