/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMFileHelper;
import java.io.File;

public abstract class EMFileMessageBody
extends EMMessageBody {
    public EMFileMessageBody(String localPath) {
        this(EMFileHelper.getInstance().formatInUri(localPath));
    }

    public EMFileMessageBody(Uri localPath) {
        this(localPath, 5);
    }

    EMFileMessageBody(String localPath, int type) {
        this(Uri.fromFile((File)new File(localPath)), type);
    }

    EMFileMessageBody(Uri localPath, int type) {
        switch (type) {
            case 5: {
                this.emaObject = new EMAFileMessageBody(localPath, type);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 1: {
                this.emaObject = new EMAImageMessageBody(localPath, null);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 2: {
                this.emaObject = new EMAVideoMessageBody(localPath, null);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 4: {
                this.emaObject = new EMAVoiceMessageBody(localPath, 0);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
                break;
            }
        }
    }

    public EMFileMessageBody(EMAFileMessageBody body) {
        this.emaObject = body;
    }

    public String getFileName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileName(String fileName) {
        ((EMAFileMessageBody)this.emaObject).setDisplayName(fileName);
    }

    public String getLocalUrl() {
        return EMFileHelper.getInstance().formatOutLocalUrl(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(String localUrl) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(localUrl));
    }

    public Uri getLocalUri() {
        return EMFileHelper.getInstance().formatOutUri(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(Uri localUrl) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(localUrl));
    }

    public String getRemoteUrl() {
        return ((EMAFileMessageBody)this.emaObject).getRemoteUrl();
    }

    public void setRemoteUrl(String remoteUrl) {
        ((EMAFileMessageBody)this.emaObject).setRemotePath(remoteUrl);
    }

    public void setSecret(String secret) {
        ((EMAFileMessageBody)this.emaObject).setSecretKey(secret);
    }

    public String getSecret() {
        return ((EMAFileMessageBody)this.emaObject).getSecret();
    }

    public String displayName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileLength(long length) {
        ((EMAFileMessageBody)this.emaObject).setFileLength(length);
    }

    public EMDownloadStatus downloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAFileMessageBody)this.emaObject).downloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return EMDownloadStatus.PENDING;
            }
        }
        return EMDownloadStatus.SUCCESSED;
    }

    public void setDownloadStatus(EMDownloadStatus status) {
        ((EMAFileMessageBody)this.emaObject).setDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(status.name()));
    }

    public static enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING;

    }
}

