/*
 * Decompiled with CFR 0.152.
 */
package io.hexhacking.xunwind;

public class XUnwind {
    private static final int currentProcess = -1;
    private static final int currentThread = -1;
    private static final int allThreads = -2;
    private static boolean initialized = false;

    public static synchronized void init() throws SecurityException, UnsatisfiedLinkError {
        XUnwind.init(null);
    }

    public static synchronized void init(ILibLoader libLoader) throws SecurityException, UnsatisfiedLinkError {
        if (initialized) {
            return;
        }
        if (libLoader == null) {
            System.loadLibrary("xunwind");
        } else {
            libLoader.loadLibrary("xunwind");
        }
        initialized = true;
    }

    private static void log(int pid, int tid, String logtag, int priority, String prefix) {
        if (!initialized) {
            return;
        }
        XUnwind.nativeLog(pid, tid, logtag, priority, prefix);
    }

    public static void logLocalCurrentThread(String logtag, int priority, String prefix) {
        XUnwind.log(-1, -1, logtag, priority, prefix);
    }

    public static void logLocalCurrentThread(String logtag, int priority) {
        XUnwind.log(-1, -1, logtag, priority, null);
    }

    public static void logLocalThread(int tid, String logtag, int priority, String prefix) {
        XUnwind.log(-1, tid, logtag, priority, prefix);
    }

    public static void logLocalThread(int tid, String logtag, int priority) {
        XUnwind.log(-1, tid, logtag, priority, null);
    }

    public static void logLocalAllThread(String logtag, int priority, String prefix) {
        XUnwind.log(-1, -2, logtag, priority, prefix);
    }

    public static void logLocalAllThread(String logtag, int priority) {
        XUnwind.log(-1, -2, logtag, priority, null);
    }

    public static void logRemoteThread(int pid, int tid, String logtag, int priority, String prefix) {
        XUnwind.log(pid, tid, logtag, priority, prefix);
    }

    public static void logRemoteThread(int pid, int tid, String logtag, int priority) {
        XUnwind.log(pid, tid, logtag, priority, null);
    }

    public static void logRemoteAllThread(int pid, String logtag, int priority, String prefix) {
        XUnwind.log(pid, -2, logtag, priority, prefix);
    }

    public static void logRemoteAllThread(int pid, String logtag, int priority) {
        XUnwind.log(pid, -2, logtag, priority, null);
    }

    private static void dump(int pid, int tid, int fd, String prefix) {
        if (!initialized) {
            return;
        }
        XUnwind.nativeDump(pid, tid, fd, prefix);
    }

    public static void dumpLocalCurrentThread(int fd, String prefix) {
        XUnwind.dump(-1, -1, fd, prefix);
    }

    public static void dumpLocalCurrentThread(int fd) {
        XUnwind.dump(-1, -1, fd, null);
    }

    public static void dumpLocalThread(int tid, int fd, String prefix) {
        XUnwind.dump(-1, tid, fd, prefix);
    }

    public static void dumpLocalThread(int tid, int fd) {
        XUnwind.dump(-1, tid, fd, null);
    }

    public static void dumpLocalAllThread(int fd, String prefix) {
        XUnwind.dump(-1, -2, fd, prefix);
    }

    public static void dumpLocalAllThread(int fd) {
        XUnwind.dump(-1, -2, fd, null);
    }

    public static void dumpRemoteThread(int pid, int tid, int fd, String prefix) {
        XUnwind.dump(pid, tid, fd, prefix);
    }

    public static void dumpRemoteThread(int pid, int tid, int fd) {
        XUnwind.dump(pid, tid, fd, null);
    }

    public static void dumpRemoteAllThread(int pid, int fd, String prefix) {
        XUnwind.dump(pid, -2, fd, prefix);
    }

    public static void dumpRemoteAllThread(int pid, int fd) {
        XUnwind.dump(pid, -2, fd, null);
    }

    private static String get(int pid, int tid, String prefix) {
        if (!initialized) {
            return null;
        }
        return XUnwind.nativeGet(pid, tid, prefix);
    }

    public static String getLocalCurrentThread(String prefix) {
        return XUnwind.get(-1, -1, prefix);
    }

    public static String getLocalCurrentThread() {
        return XUnwind.get(-1, -1, null);
    }

    public static String getLocalThread(int tid, String prefix) {
        return XUnwind.get(-1, tid, prefix);
    }

    public static String getLocalThread(int tid) {
        return XUnwind.get(-1, tid, null);
    }

    public static String getLocalAllThread(String prefix) {
        return XUnwind.get(-1, -2, prefix);
    }

    public static String getLocalAllThread() {
        return XUnwind.get(-1, -2, null);
    }

    public static String getRemoteThread(int pid, int tid, String prefix) {
        return XUnwind.get(pid, tid, prefix);
    }

    public static String getRemoteThread(int pid, int tid) {
        return XUnwind.get(pid, tid, null);
    }

    public static String getRemoteAllThread(int pid, String prefix) {
        return XUnwind.get(pid, -2, prefix);
    }

    public static String getRemoteAllThread(int pid) {
        return XUnwind.get(pid, -2, null);
    }

    private static native void nativeLog(int var0, int var1, String var2, int var3, String var4);

    private static native void nativeDump(int var0, int var1, int var2, String var3);

    private static native String nativeGet(int var0, int var1, String var2);

    public static interface ILibLoader {
        public void loadLibrary(String var1);
    }
}

