/*
 * Decompiled with CFR 0.152.
 */
package xcrash;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.system.Os;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import xcrash.XCrash;

class Util {
    private static final String memInfoFmt = "%21s %8s\n";
    private static final String memInfoFmt2 = "%21s %8s %21s %8s\n";
    static final String TAG = "xcrash";
    static final String sepHead = "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***";
    static final String sepOtherThreads = "--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---";
    static final String sepOtherThreadsEnding = "+++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++ +++";
    static final String timeFormatterStr = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String javaCrashType = "java";
    static final String nativeCrashType = "native";
    static final String anrCrashType = "anr";
    static final String logPrefix = "tombstone";
    static final String javaLogSuffix = ".java.xcrash";
    static final String nativeLogSuffix = ".native.xcrash";
    static final String anrLogSuffix = ".anr.xcrash";
    static final String traceLogSuffix = ".trace.xcrash";
    private static final String[] suPathname = new String[]{"/data/local/su", "/data/local/bin/su", "/data/local/xbin/su", "/system/xbin/su", "/system/bin/su", "/system/bin/.ext/su", "/system/bin/failsafe/su", "/system/sd/xbin/su", "/system/usr/we-need-root/su", "/sbin/su", "/su/bin/su"};

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getProcessName(Context ctx, int pid) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/proc/" + pid + "/cmdline"));
            String processName = br.readLine();
            if (!TextUtils.isEmpty((CharSequence)processName) && !TextUtils.isEmpty((CharSequence)(processName = processName.trim()))) {
                String string = processName;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    static boolean isRoot() {
        try {
            for (String path : suPathname) {
                File file = new File(path);
                if (!file.exists()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static String getAbiList() {
        if (Build.VERSION.SDK_INT >= 21) {
            return TextUtils.join((CharSequence)",", (Object[])Build.SUPPORTED_ABIS);
        }
        String abi = Build.CPU_ABI;
        String abi2 = Build.CPU_ABI2;
        if (TextUtils.isEmpty((CharSequence)abi2)) {
            return abi;
        }
        return abi + "," + abi2;
    }

    static String getAppVersion(Context ctx) {
        String appVersion = null;
        try {
            appVersion = ctx.getPackageManager().getPackageInfo((String)ctx.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty(appVersion)) {
            appVersion = "unknown";
        }
        return appVersion;
    }

    static String getProcessMemoryInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Process Summary (From: android.os.Debug.MemoryInfo)\n");
        sb.append(String.format(Locale.US, memInfoFmt, "", "Pss(KB)"));
        sb.append(String.format(Locale.US, memInfoFmt, "", "------"));
        try {
            Debug.MemoryInfo mi = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)mi);
            if (Build.VERSION.SDK_INT >= 23) {
                sb.append(String.format(Locale.US, memInfoFmt, "Java Heap:", mi.getMemoryStat("summary.java-heap")));
                sb.append(String.format(Locale.US, memInfoFmt, "Native Heap:", mi.getMemoryStat("summary.native-heap")));
                sb.append(String.format(Locale.US, memInfoFmt, "Code:", mi.getMemoryStat("summary.code")));
                sb.append(String.format(Locale.US, memInfoFmt, "Stack:", mi.getMemoryStat("summary.stack")));
                sb.append(String.format(Locale.US, memInfoFmt, "Graphics:", mi.getMemoryStat("summary.graphics")));
                sb.append(String.format(Locale.US, memInfoFmt, "Private Other:", mi.getMemoryStat("summary.private-other")));
                sb.append(String.format(Locale.US, memInfoFmt, "System:", mi.getMemoryStat("summary.system")));
                sb.append(String.format(Locale.US, memInfoFmt2, "TOTAL:", mi.getMemoryStat("summary.total-pss"), "TOTAL SWAP:", mi.getMemoryStat("summary.total-swap")));
            } else {
                sb.append(String.format(Locale.US, memInfoFmt, "Java Heap:", "~ " + mi.dalvikPrivateDirty));
                sb.append(String.format(Locale.US, memInfoFmt, "Native Heap:", String.valueOf(mi.nativePrivateDirty)));
                sb.append(String.format(Locale.US, memInfoFmt, "Private Other:", "~ " + mi.otherPrivateDirty));
                if (Build.VERSION.SDK_INT >= 19) {
                    sb.append(String.format(Locale.US, memInfoFmt, "System:", String.valueOf(mi.getTotalPss() - mi.getTotalPrivateDirty() - mi.getTotalPrivateClean())));
                } else {
                    sb.append(String.format(Locale.US, memInfoFmt, "System:", "~ " + (mi.getTotalPss() - mi.getTotalPrivateDirty())));
                }
                sb.append(String.format(Locale.US, memInfoFmt, "TOTAL:", String.valueOf(mi.getTotalPss())));
            }
        }
        catch (Exception e) {
            XCrash.getLogger().i(TAG, "Util getProcessMemoryInfo failed", e);
        }
        return sb.toString();
    }

    private static String getFileContent(String pathname) {
        return Util.getFileContent(pathname, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(String pathname, int limit) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        int n = 0;
        try {
            String line;
            br = new BufferedReader(new FileReader(pathname));
            while (null != (line = br.readLine())) {
                String p = line.trim();
                if (p.length() <= 0 || limit != 0 && ++n > limit) continue;
                sb.append("  ").append(p).append("\n");
            }
            if (limit > 0 && n > limit) {
                sb.append("  ......\n").append("  (number of records: ").append(n).append(")\n");
            }
        }
        catch (Exception e) {
            XCrash.getLogger().i(TAG, "Util getInfo(" + pathname + ") failed", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    static boolean checkAndCreateDir(String path) {
        File dir = new File(path);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
                return dir.exists() && dir.isDirectory();
            }
            return dir.isDirectory();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static boolean checkProcessAnrState(Context ctx, long timeoutMs) {
        ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
        if (am == null) {
            return false;
        }
        int pid = android.os.Process.myPid();
        long poll = timeoutMs / 500L;
        int i = 0;
        while ((long)i < poll) {
            List processErrorList = am.getProcessesInErrorState();
            if (processErrorList != null) {
                for (ActivityManager.ProcessErrorStateInfo errorStateInfo : processErrorList) {
                    if (errorStateInfo.pid != pid || errorStateInfo.condition != 2) continue;
                    return true;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }

    static String getLogHeader(Date startTime, Date crashTime, String crashType, String appId, String appVersion) {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(timeFormatterStr, Locale.US);
        return "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***\nTombstone maker: 'xCrash 3.0.0'\nCrash type: '" + crashType + "'\nStart time: '" + timeFormatter.format(startTime) + "'\nCrash time: '" + timeFormatter.format(crashTime) + "'\nApp ID: '" + appId + "'\nApp version: '" + appVersion + "'\nRooted: '" + (Util.isRoot() ? "Yes" : "No") + "'\nAPI level: '" + Build.VERSION.SDK_INT + "'\nOS version: '" + Build.VERSION.RELEASE + "'\nABI list: '" + Util.getAbiList() + "'\nManufacturer: '" + Build.MANUFACTURER + "'\nBrand: '" + Build.BRAND + "'\nModel: '" + Build.MODEL + "'\nBuild fingerprint: '" + Build.FINGERPRINT + "'\n";
    }

    static String getMemoryInfo() {
        return "memory info:\n System Summary (From: /proc/meminfo)\n" + Util.getFileContent("/proc/meminfo") + "-\n Process Status (From: /proc/PID/status)\n" + Util.getFileContent("/proc/self/status") + "-\n Process Limits (From: /proc/PID/limits)\n" + Util.getFileContent("/proc/self/limits") + "-\n" + Util.getProcessMemoryInfo() + "\n";
    }

    static String getNetworkInfo() {
        if (Build.VERSION.SDK_INT >= 29) {
            return "network info:\nNot supported on Android Q (API level 29) and later.\n\n";
        }
        return "network info:\n TCP over IPv4 (From: /proc/PID/net/tcp)\n" + Util.getFileContent("/proc/self/net/tcp", 1024) + "-\n TCP over IPv6 (From: /proc/PID/net/tcp6)\n" + Util.getFileContent("/proc/self/net/tcp6", 1024) + "-\n UDP over IPv4 (From: /proc/PID/net/udp)\n" + Util.getFileContent("/proc/self/net/udp", 1024) + "-\n UDP over IPv6 (From: /proc/PID/net/udp6)\n" + Util.getFileContent("/proc/self/net/udp6", 1024) + "-\n ICMP in IPv4 (From: /proc/PID/net/icmp)\n" + Util.getFileContent("/proc/self/net/icmp", 256) + "-\n ICMP in IPv6 (From: /proc/PID/net/icmp6)\n" + Util.getFileContent("/proc/self/net/icmp6", 256) + "-\n UNIX domain (From: /proc/PID/net/unix)\n" + Util.getFileContent("/proc/self/net/unix", 256) + "\n";
    }

    static String getFds() {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder("open files:\n");
            try {
                File dir = new File("/proc/self/fd");
                File[] fds = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return TextUtils.isDigitsOnly((CharSequence)name);
                    }
                });
                int count = 0;
                if (fds == null) break block6;
                for (File fd : fds) {
                    String path = null;
                    try {
                        path = Build.VERSION.SDK_INT >= 21 ? Os.readlink((String)fd.getAbsolutePath()) : fd.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append("    fd ").append(fd.getName()).append(": ").append(TextUtils.isEmpty((CharSequence)path) ? "???" : path.trim()).append('\n');
                    if (++count > 1024) break;
                }
                if (fds.length > 1024) {
                    sb.append("    ......\n");
                }
                sb.append("    (number of FDs: ").append(fds.length).append(")\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    static String getLogcat(int logcatMainLines, int logcatSystemLines, int logcatEventsLines) {
        int pid = android.os.Process.myPid();
        StringBuilder sb = new StringBuilder();
        sb.append("logcat:\n");
        if (logcatMainLines > 0) {
            Util.getLogcatByBufferName(pid, sb, "main", logcatMainLines, 'D');
        }
        if (logcatSystemLines > 0) {
            Util.getLogcatByBufferName(pid, sb, "system", logcatSystemLines, 'W');
        }
        if (logcatEventsLines > 0) {
            Util.getLogcatByBufferName(pid, sb, "events", logcatSystemLines, 'I');
        }
        sb.append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLogcatByBufferName(int pid, StringBuilder sb, String bufferName, int lines, char priority) {
        boolean withPid = Build.VERSION.SDK_INT >= 24;
        String pidString = Integer.toString(pid);
        String pidLabel = " " + pidString + " ";
        ArrayList<String> command = new ArrayList<String>();
        command.add("/system/bin/logcat");
        command.add("-b");
        command.add(bufferName);
        command.add("-d");
        command.add("-v");
        command.add("threadtime");
        command.add("-t");
        command.add(Integer.toString(withPid ? lines : (int)((double)lines * 1.2)));
        if (withPid) {
            command.add("--pid");
            command.add(pidString);
        }
        command.add("*:" + priority);
        Object[] commandArray = command.toArray();
        sb.append("--------- tail end of log ").append(bufferName);
        sb.append(" (").append(TextUtils.join((CharSequence)" ", (Object[])commandArray)).append(")\n");
        BufferedReader br = null;
        try {
            String line;
            Process process = new ProcessBuilder(new String[0]).command(command).start();
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!withPid && !line.contains(pidLabel)) continue;
                sb.append(line).append("\n");
            }
        }
        catch (Exception e) {
            XCrash.getLogger().w(TAG, "Util run logcat command failed", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

