/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.optimization;

import com.google.common.base.MoreObjects;
import io.prestosql.spi.connector.CatalogName;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.plan.Symbol;
import io.prestosql.spi.sql.expression.OrderBy;
import io.prestosql.spi.sql.expression.Selection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public final class JdbcQueryGeneratorContext {
    private final Optional<CatalogName> catalogName;
    private final Optional<SchemaTableName> schemaTableName;
    private final String remoteCatalogName;
    private final String remoteSchemaName;
    private final String remoteTableName;
    private final Optional<ConnectorTransactionHandle> transaction;
    private final LinkedHashMap<String, Selection> selections;
    private final Set<String> groupByColumns;
    private final Optional<String> from;
    private final Optional<String> filter;
    private final OptionalLong limit;
    private final Optional<List<OrderBy>> orderBy;
    private final boolean hasPushDown;
    private final GroupIdNodeInfo groupIdNodeInfo;

    private JdbcQueryGeneratorContext(Optional<CatalogName> catalogName, Optional<SchemaTableName> schemaTableName, String remoteCatalogName, String remoteSchemaName, String remoteTableName, Optional<ConnectorTransactionHandle> transaction, Map<String, Selection> selections, Optional<String> from, Set<String> groupByColumns, Optional<String> filter, OptionalLong limit, Optional<List<OrderBy>> orderBy, GroupIdNodeInfo groupIdNodeInfo, boolean hasPushDown) {
        this.catalogName = catalogName;
        this.schemaTableName = schemaTableName;
        this.remoteCatalogName = remoteCatalogName;
        this.remoteSchemaName = remoteSchemaName;
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "table name is null");
        this.transaction = transaction;
        this.selections = new LinkedHashMap<String, Selection>(Objects.requireNonNull(selections, "selections can't be null"));
        this.from = Objects.requireNonNull(from, "from can't be null");
        this.groupByColumns = new HashSet<String>((Collection)Objects.requireNonNull(groupByColumns, "groupByColumns can't be null. It could be empty if not available."));
        this.filter = Objects.requireNonNull(filter);
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.orderBy = orderBy;
        this.groupIdNodeInfo = groupIdNodeInfo;
        this.hasPushDown = hasPushDown;
    }

    public Optional<CatalogName> getCatalogName() {
        return this.catalogName;
    }

    public Optional<SchemaTableName> getSchemaTableName() {
        return this.schemaTableName;
    }

    public String getRemoteCatalogName() {
        return this.remoteCatalogName;
    }

    public String getRemoteSchemaName() {
        return this.remoteSchemaName;
    }

    public String getRemoteTableName() {
        return this.remoteTableName;
    }

    public Optional<ConnectorTransactionHandle> getTransaction() {
        return this.transaction;
    }

    public LinkedHashMap<String, Selection> getSelections() {
        return this.selections;
    }

    public Optional<String> getFrom() {
        return this.from;
    }

    public Set<String> getGroupByColumns() {
        return this.groupByColumns;
    }

    public Optional<String> getFilter() {
        return this.filter;
    }

    public OptionalLong getLimit() {
        return this.limit;
    }

    public Optional<List<OrderBy>> getOrderBy() {
        return this.orderBy;
    }

    public GroupIdNodeInfo getGroupIdNodeInfo() {
        return this.groupIdNodeInfo;
    }

    public boolean isHasPushDown() {
        return this.hasPushDown;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selections", this.selections).add("from", this.from).add("filter", this.filter).add("limit", (Object)this.limit).add("groupByColumns", this.groupByColumns).add("orderingSchema", this.orderBy).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(JdbcQueryGeneratorContext context) {
        return new Builder(context);
    }

    public static Builder buildAsNewTable(JdbcQueryGeneratorContext context) {
        return new Builder(context.getCatalogName(), context.getSchemaTableName(), context.getRemoteCatalogName(), context.getRemoteSchemaName(), context.getRemoteTableName(), context.getTransaction(), context.getGroupIdNodeInfo());
    }

    public static final class Builder {
        private Optional<CatalogName> catalogName;
        private Optional<SchemaTableName> schemaTableName;
        private String remoteCatalogName;
        private String remoteSchemaName;
        private String remoteTableName;
        private Optional<ConnectorTransactionHandle> transaction;
        private LinkedHashMap<String, Selection> selections = new LinkedHashMap();
        private Set<String> groupByColumns = new HashSet<String>();
        private Optional<String> from = Optional.empty();
        private Optional<String> filter = Optional.empty();
        private OptionalLong limit = OptionalLong.empty();
        private Optional<List<OrderBy>> orderBy = Optional.empty();
        private GroupIdNodeInfo groupIdNodeInfo = new GroupIdNodeInfo();
        private boolean hasPushDown;

        public Builder() {
        }

        private Builder(JdbcQueryGeneratorContext context) {
            this.catalogName = context.getCatalogName();
            this.schemaTableName = context.getSchemaTableName();
            this.remoteCatalogName = context.getRemoteCatalogName();
            this.remoteSchemaName = context.getRemoteSchemaName();
            this.remoteTableName = context.getRemoteTableName();
            this.transaction = context.getTransaction();
            this.selections = context.getSelections();
            this.groupByColumns = context.getGroupByColumns();
            this.from = context.getFrom();
            this.filter = context.getFilter();
            this.limit = context.getLimit();
            this.orderBy = context.getOrderBy();
            this.hasPushDown = context.isHasPushDown();
            this.groupIdNodeInfo = context.getGroupIdNodeInfo();
        }

        private Builder(Optional<CatalogName> catalogName, Optional<SchemaTableName> schemaTableName, String remoteCatalogName, String remoteSchemaName, String remoteTableName, Optional<ConnectorTransactionHandle> transaction, GroupIdNodeInfo groupIdNodeInfo) {
            this.catalogName = catalogName;
            this.schemaTableName = schemaTableName;
            this.remoteCatalogName = remoteCatalogName;
            this.remoteSchemaName = remoteSchemaName;
            this.remoteTableName = remoteTableName;
            this.transaction = transaction;
            this.groupIdNodeInfo = groupIdNodeInfo;
        }

        public Builder setCatalogName(Optional<CatalogName> catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setSchemaTableName(Optional<SchemaTableName> schemaTableName) {
            this.schemaTableName = schemaTableName;
            return this;
        }

        public Builder setRemoteCatalogName(String catalogname) {
            this.remoteCatalogName = catalogname;
            return this;
        }

        public Builder setRemoteSchemaName(String schemaName) {
            this.remoteSchemaName = schemaName;
            return this;
        }

        public Builder setRemoteTablename(String tableName) {
            this.remoteTableName = tableName;
            return this;
        }

        public Builder setTransaction(Optional<ConnectorTransactionHandle> transaction) {
            this.transaction = transaction;
            return this;
        }

        public Builder setSelections(LinkedHashMap<String, Selection> selections) {
            this.selections = selections;
            return this;
        }

        public Builder setGroupByColumns(Set<String> groupByColumns) {
            this.groupByColumns = groupByColumns;
            return this;
        }

        public Builder setFrom(Optional<String> from) {
            this.from = from;
            return this;
        }

        public Builder setFilter(Optional<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder setLimit(OptionalLong limit) {
            this.limit = limit;
            return this;
        }

        public Builder setOrderBy(Optional<List<OrderBy>> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder setHasPushDown(boolean hasPushDown) {
            this.hasPushDown = hasPushDown;
            return this;
        }

        public Builder setOutputColumns(List<Symbol> outputColumns) {
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>();
            for (Symbol out : outputColumns) {
                if (this.groupIdNodeInfo.getGroupingElementStore().containsKey(out)) continue;
                newSelections.put(out.getName(), Objects.requireNonNull(this.selections.get(out.getName()), "Cannot find the selection " + out.getName() + " in the original context."));
            }
            this.selections = newSelections;
            return this;
        }

        public Builder setGroupIdNodeInfo(GroupIdNodeInfo groupIdNodeInfo) {
            this.groupIdNodeInfo = groupIdNodeInfo;
            return this;
        }

        public JdbcQueryGeneratorContext build() {
            return new JdbcQueryGeneratorContext(this.catalogName, this.schemaTableName, this.remoteCatalogName, this.remoteSchemaName, this.remoteTableName, this.transaction, this.selections, this.from, this.groupByColumns, this.filter, this.limit, this.orderBy, this.groupIdNodeInfo, this.hasPushDown);
        }
    }

    public static class GroupIdNodeInfo {
        private boolean isGroupByComplexOperation;
        private Map<Symbol, String> groupingElementStore = new HashMap<Symbol, String>();

        GroupIdNodeInfo() {
        }

        public boolean isGroupByComplexOperation() {
            return this.isGroupByComplexOperation;
        }

        public void setGroupByComplexOperation(boolean groupByComplexOperation) {
            this.isGroupByComplexOperation = groupByComplexOperation;
        }

        public Map<Symbol, String> getGroupingElementStore() {
            return this.groupingElementStore;
        }

        public void setGroupingElementStore(Map<Symbol, String> groupingElementStore) {
            this.groupingElementStore = groupingElementStore;
        }
    }
}

