/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.google.common.base.Preconditions;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.hetu.core.transport.execution.buffer.PagesSerde;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.spiller.SpillCipher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;

public class SliceStreamPageSerde
extends PagesSerde {
    private final BlockEncodingSerde serde;

    public SliceStreamPageSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
        super(blockEncodingSerde, compressor, decompressor, spillCipher);
        this.serde = blockEncodingSerde;
    }

    @Override
    public void serialize(OutputStream output, Page page) {
        Preconditions.checkArgument((boolean)(output instanceof SliceOutput), (Object)("Page serializer does not support (" + output.getClass().getSimpleName() + ") for writing"));
        this.writePage((SliceOutput)output, page);
    }

    @Override
    public Page deserialize(InputStream input) {
        Preconditions.checkArgument((boolean)(input instanceof SliceInput), (Object)("Page serializer does not support (" + input.getClass().getSimpleName() + ") for reading"));
        return this.readPage((SliceInput)input);
    }

    private void writePage(SliceOutput output, Page page) {
        output.writeInt(page.getPositionCount());
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            this.serde.writeBlock(output, page.getBlock(channel));
        }
        if (page.getPageMetadata().size() > 0) {
            String pageProperties = page.getPageMetadata().toString();
            byte[] propertiesByte = pageProperties.replaceAll(",", System.lineSeparator()).substring(1, pageProperties.length() - 1).getBytes(StandardCharsets.UTF_8);
            output.writeInt(propertiesByte.length);
            output.writeBytes(propertiesByte);
        } else {
            output.writeInt(0);
        }
    }

    public Page readPage(SliceInput input) {
        int positionCount = input.readInt();
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.serde.readBlock(input);
        }
        int propSize = input.readInt();
        if (propSize > 0) {
            byte[] pageMetadataBytes = new byte[propSize];
            input.readBytes(pageMetadataBytes);
            Properties pros = new Properties();
            try {
                pros.load(new ByteArrayInputStream(pageMetadataBytes));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new Page(positionCount, pros, blocks);
        }
        return new Page(positionCount, blocks);
    }
}

