/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.hetu.core.transport.execution.buffer.PagesSerde;
import io.hetu.core.transport.execution.buffer.SliceStreamPageSerde;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.spiller.SpillCipher;
import java.util.Objects;
import java.util.Optional;

public class PagesSerdeFactory {
    private final BlockEncodingSerde blockEncodingSerde;
    private final boolean compressionEnabled;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, boolean compressionEnabled) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionEnabled = compressionEnabled;
    }

    public PagesSerde createPagesSerde() {
        return this.createPagesSerdeInternal(Optional.empty(), false);
    }

    public PagesSerde createPagesSerdeForSpill(Optional<SpillCipher> spillCipher, boolean useDirectSerde) {
        return this.createPagesSerdeInternal(spillCipher, useDirectSerde);
    }

    private PagesSerde createPagesSerdeInternal(Optional<SpillCipher> spillCipher, boolean useDirectSerde) {
        if (useDirectSerde) {
            return new SliceStreamPageSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), spillCipher);
        }
        if (this.compressionEnabled) {
            return new PagesSerde(this.blockEncodingSerde, Optional.of(new ZstdCompressor()), Optional.of(new ZstdDecompressor()), spillCipher);
        }
        return new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), spillCipher);
    }
}

