/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UpdateIndex
extends Statement {
    private final QualifiedName indexName;
    private final boolean exists;
    private final List<Property> properties;

    public UpdateIndex(QualifiedName indexName, boolean exists, List<Property> properties) {
        this(Optional.empty(), indexName, exists, properties);
    }

    public UpdateIndex(NodeLocation location, QualifiedName indexName, boolean exists, List<Property> properties) {
        this(Optional.of(location), indexName, exists, properties);
    }

    private UpdateIndex(Optional<NodeLocation> location, QualifiedName indexName, boolean exists, List<Property> properties) {
        super(location);
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
        this.exists = exists;
        this.properties = properties;
    }

    public QualifiedName getIndexName() {
        return this.indexName;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdateIndex(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)((Node)((Object)this.properties)));
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexName, this.exists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateIndex o = (UpdateIndex)obj;
        return Objects.equals(this.indexName, o.indexName) && Objects.equals(this.exists, o.exists) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexName", (Object)this.indexName).add("notExists", this.exists).add("properties", this.properties).toString();
    }
}

