/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.optimization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterTableHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.optimization.BaseJdbcQueryGenerator;
import io.prestosql.plugin.jdbc.optimization.BaseJdbcRowExpressionConverter;
import io.prestosql.plugin.jdbc.optimization.BaseJdbcSqlStatementWriter;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizerUtils;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownParameter;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorContext;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.metadata.TableHandle;
import io.prestosql.spi.plan.PlanNode;
import io.prestosql.spi.plan.PlanVisitor;
import io.prestosql.spi.plan.TableScanNode;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.relation.DeterminismEvaluator;
import io.prestosql.spi.relation.RowExpressionService;
import io.prestosql.spi.sql.SqlStatementWriter;
import io.prestosql.spi.sql.expression.Selection;
import io.prestosql.spi.type.TypeManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class DataCenterQueryGenerator
extends BaseJdbcQueryGenerator {
    @Inject
    public DataCenterQueryGenerator(DataCenterConfig config, RowExpressionService rowExpressionService, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator) {
        super(new JdbcPushDownParameter("\"", false, config.getQueryPushDownModule(), functionResolution), new BaseJdbcRowExpressionConverter(functionManager, functionResolution, rowExpressionService, determinismEvaluator), (SqlStatementWriter)new BaseJdbcSqlStatementWriter(new JdbcPushDownParameter("\"", false, config.getQueryPushDownModule(), functionResolution)));
    }

    protected PlanVisitor<Optional<JdbcQueryGeneratorContext>, Void> getVisitor(TypeManager typeManager) {
        return new DataCenterPlanVisitor(typeManager);
    }

    protected class DataCenterPlanVisitor
    extends BaseJdbcQueryGenerator.BaseJdbcPlanVisitor {
        public DataCenterPlanVisitor(TypeManager typeManager) {
            super((BaseJdbcQueryGenerator)DataCenterQueryGenerator.this, typeManager);
        }

        public Optional<JdbcQueryGeneratorContext> visitPlan(PlanNode node, Void contextIn) {
            log.debug("JDBC query generator failed for [%s]", new Object[]{"Don't know how to handle plan node of type " + node});
            return Optional.empty();
        }

        public Optional<JdbcQueryGeneratorContext> visitTableScan(TableScanNode node, Void contextIn) {
            String tableName;
            String schemaName;
            this.checkAvailable((PlanNode)node);
            Preconditions.checkArgument((boolean)(node.getTable().getConnectorHandle() instanceof DataCenterTableHandle), (Object)"Expected to find Data Center table handle for the scan node");
            TupleDomain constraint = node.getEnforcedConstraint();
            if (constraint != null && constraint.getDomains().isPresent() && !((Map)constraint.getDomains().get()).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Cannot push down table scan with predicates pushed down");
            }
            TableHandle tableHandle = node.getTable();
            DataCenterTableHandle dcTableHandle = (DataCenterTableHandle)node.getTable().getConnectorHandle();
            Preconditions.checkArgument((boolean)dcTableHandle.getPushDownSql().isEmpty(), (Object)"Data center should not have sql before pushdown");
            LinkedHashMap selections = new LinkedHashMap();
            node.getOutputSymbols().forEach(outputColumn -> {
                DataCenterColumnHandle dcColumn = (DataCenterColumnHandle)node.getAssignments().get(outputColumn);
                selections.put(outputColumn.getName(), new Selection(dcColumn.getColumnName(), outputColumn.getName()));
            });
            StringBuilder table = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)dcTableHandle.getCatalogName())) {
                table.append(JdbcPlanOptimizerUtils.quote((String)DataCenterQueryGenerator.this.quote, (String)dcTableHandle.getCatalogName())).append('.');
            }
            if (!Strings.isNullOrEmpty((String)dcTableHandle.getSchemaName())) {
                table.append(JdbcPlanOptimizerUtils.quote((String)DataCenterQueryGenerator.this.quote, (String)dcTableHandle.getSchemaName())).append('.');
            }
            table.append(JdbcPlanOptimizerUtils.quote((String)DataCenterQueryGenerator.this.quote, (String)dcTableHandle.getTableName()));
            JdbcQueryGeneratorContext.Builder contextBuilder = new JdbcQueryGeneratorContext.Builder().setCatalogName(Optional.of(tableHandle.getCatalogName())).setTransaction(Optional.of(tableHandle.getTransaction())).setSchemaTableName(Optional.of(new SchemaTableName(dcTableHandle.getSchemaName(), dcTableHandle.getTableName()))).setSelections(selections).setFrom(Optional.of(table.toString()));
            String catalogName = dcTableHandle.getCatalogName();
            if (catalogName != null) {
                contextBuilder.setRemoteCatalogName(catalogName);
            }
            if ((schemaName = dcTableHandle.getSchemaName()) != null) {
                contextBuilder.setRemoteSchemaName(schemaName);
            }
            if ((tableName = dcTableHandle.getTableName()) != null) {
                contextBuilder.setRemoteTablename(tableName);
            }
            if (dcTableHandle.getLimit().isPresent()) {
                contextBuilder.setLimit(dcTableHandle.getLimit());
                contextBuilder.setHasPushDown(true);
            }
            return Optional.of(contextBuilder.build());
        }
    }
}

