/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableList;
import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.hetu.core.plugin.datacenter.DataCenterTable;
import io.hetu.core.plugin.datacenter.MetadataUtil;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDataCenterTable {
    private final DataCenterTable dataCenterTable = new DataCenterTable("tableName", (List)ImmutableList.of((Object)new DataCenterColumn("a", (Type)VarcharType.createUnboundedVarcharType()), (Object)new DataCenterColumn("b", (Type)BigintType.BIGINT)));

    @Test
    public void testColumnMetadata() {
        Assert.assertEquals((Collection)this.dataCenterTable.getColumnsMetadata(), (Collection)ImmutableList.of((Object)new ColumnMetadata("a", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT)));
    }

    @Test
    public void testRoundTrip() {
        String json = MetadataUtil.TABLE_CODEC.toJson((Object)this.dataCenterTable);
        DataCenterTable dataCenterTableCopy = (DataCenterTable)MetadataUtil.TABLE_CODEC.fromJson(json);
        Assert.assertEquals((String)dataCenterTableCopy.getName(), (String)this.dataCenterTable.getName());
        Assert.assertEquals((Collection)dataCenterTableCopy.getColumns(), (Collection)this.dataCenterTable.getColumns());
    }
}

