/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterMetadata;
import io.hetu.core.plugin.datacenter.DataCenterTableHandle;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.testing.TestingTypeManager;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDataCenterMetadata {
    private static final Logger log = Logger.get(TestDataCenterMetadata.class);
    public static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return null;
        }

        public Optional<String> getSource() {
            return Optional.empty();
        }

        public ConnectorIdentity getIdentity() {
            return null;
        }

        public TimeZoneKey getTimeZoneKey() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public Optional<String> getTraceToken() {
            return Optional.empty();
        }

        public long getStartTime() {
            return 0L;
        }

        public <T> T getProperty(String name, Class<T> type) {
            return null;
        }

        public Optional<String> getCatalog() {
            return Optional.of("tpch");
        }
    };
    private static final DataCenterTableHandle NUMBERS_TABLE_HANDLE = new DataCenterTableHandle("tpch", "tiny", "orders", OptionalLong.empty());
    private TypeManager typeManager = new TestingTypeManager();
    private TestingPrestoServer server;
    private URI baseUri;
    private OkHttpClient httpClient;
    private DataCenterMetadata metadata;

    @BeforeClass
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.baseUri = this.server.getBaseUrl();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
        DataCenterConfig config = new DataCenterConfig().setConnectionUrl(this.baseUri).setConnectionUser("root");
        this.httpClient = DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)config);
        DataCenterClient client = new DataCenterClient(config, this.httpClient, this.typeManager);
        this.metadata = new DataCenterMetadata(client, config);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Test
    public void testListSchemaNames() {
        Assert.assertEquals((Collection)this.metadata.listSchemaNames(SESSION), (Collection)ImmutableSet.of((Object)"sf30000", (Object)"sf3000", (Object)"sf1000", (Object)"sf300", (Object)"tiny", (Object)"sf100000", (Object[])new String[]{"sf100", "sf10000", "sf1"}));
    }

    @Test
    public void testGetTableHandle() {
        Assert.assertEquals((Object)this.metadata.getTableHandle(SESSION, new SchemaTableName("tiny", "orders")), (Object)NUMBERS_TABLE_HANDLE);
        Assert.assertNull((Object)this.metadata.getTableHandle(SESSION, new SchemaTableName("tiny", "unknown")));
        Assert.assertNull((Object)this.metadata.getTableHandle(SESSION, new SchemaTableName("unknown", "orders")));
        Assert.assertNull((Object)this.metadata.getTableHandle(SESSION, new SchemaTableName("unknown", "unknown")));
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetColumnHandlesUnknownSchema() {
        this.metadata.getColumnHandles(SESSION, (ConnectorTableHandle)new DataCenterTableHandle("tpch", "unknown", "unknown", OptionalLong.empty()));
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testGetColumnHandlesUnknownTable() {
        this.metadata.getColumnHandles(SESSION, (ConnectorTableHandle)new DataCenterTableHandle("tpch", "tiny", "unknown", OptionalLong.empty()));
    }

    @Test
    public void testGetColumnHandles() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"orderkey", (Object)new DataCenterColumnHandle("orderkey", (Type)BigintType.BIGINT, 0)).put((Object)"custkey", (Object)new DataCenterColumnHandle("custkey", (Type)BigintType.BIGINT, 1)).put((Object)"orderstatus", (Object)new DataCenterColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1), 2)).put((Object)"totalprice", (Object)new DataCenterColumnHandle("totalprice", (Type)DoubleType.DOUBLE, 3)).put((Object)"orderdate", (Object)new DataCenterColumnHandle("orderdate", (Type)VarcharType.createVarcharType((int)15), 4)).put((Object)"orderpriority", (Object)new DataCenterColumnHandle("orderpriority", (Type)VarcharType.createVarcharType((int)15), 5)).put((Object)"clerk", (Object)new DataCenterColumnHandle("clerk", (Type)VarcharType.createUnboundedVarcharType(), 6)).put((Object)"shippriority", (Object)new DataCenterColumnHandle("shippriority", (Type)IntegerType.INTEGER, 7)).put((Object)"comment", (Object)new DataCenterColumnHandle("comment", (Type)VarcharType.createVarcharType((int)79), 8));
        Assert.assertEquals((Map)this.metadata.getColumnHandles(SESSION, (ConnectorTableHandle)NUMBERS_TABLE_HANDLE), (Map)builder.build());
    }

    @Test
    public void getTableMetadata() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new ColumnMetadata("orderkey", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("custkey", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("orderstatus", (Type)VarcharType.createVarcharType((int)1))).add((Object)new ColumnMetadata("totalprice", (Type)DoubleType.DOUBLE)).add((Object)new ColumnMetadata("orderdate", (Type)DateType.DATE)).add((Object)new ColumnMetadata("orderpriority", (Type)VarcharType.createVarcharType((int)15))).add((Object)new ColumnMetadata("clerk", (Type)VarcharType.createVarcharType((int)15))).add((Object)new ColumnMetadata("shippriority", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("comment", (Type)VarcharType.createVarcharType((int)79)));
        ConnectorTableMetadata tableMetadata = this.metadata.getTableMetadata(SESSION, (ConnectorTableHandle)NUMBERS_TABLE_HANDLE);
        Assert.assertEquals((Object)tableMetadata.getTable(), (Object)new SchemaTableName("tiny", "orders"));
        Assert.assertEquals((Collection)tableMetadata.getColumns(), (Collection)builder.build());
    }

    @Test(expectedExceptions={TableNotFoundException.class})
    public void testInvalidTableNamed() {
        this.metadata.getTableMetadata(SESSION, (ConnectorTableHandle)new DataCenterTableHandle("tpch", "unknown", "unknown", OptionalLong.empty()));
    }

    @Test
    public void testListTables() {
        List allTables = this.metadata.listTables(SESSION, Optional.empty());
        Assert.assertEquals((int)allTables.size(), (int)72);
        Assert.assertTrue((boolean)allTables.contains(new SchemaTableName("tiny", "orders")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(SESSION, Optional.of("tiny"))), (Set)ImmutableSet.of((Object)new SchemaTableName("tiny", "lineitem"), (Object)new SchemaTableName("tiny", "partsupp"), (Object)new SchemaTableName("tiny", "nation"), (Object)new SchemaTableName("tiny", "part"), (Object)new SchemaTableName("tiny", "supplier"), (Object)new SchemaTableName("tiny", "orders"), (Object[])new SchemaTableName[]{new SchemaTableName("tiny", "region"), new SchemaTableName("tiny", "customer")}));
    }

    @Test
    public void testUnknowSchema() {
        this.metadata.listTables(SESSION, Optional.of("unknown"));
    }

    @Test
    public void getColumnMetadata() {
        Assert.assertEquals((Object)this.metadata.getColumnMetadata(SESSION, (ConnectorTableHandle)NUMBERS_TABLE_HANDLE, (ColumnHandle)new DataCenterColumnHandle("text", (Type)VarcharType.createUnboundedVarcharType(), 0)), (Object)new ColumnMetadata("text", (Type)VarcharType.createUnboundedVarcharType()));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testCreateTable() {
        this.metadata.createTable(SESSION, new ConnectorTableMetadata(new SchemaTableName("example", "foo"), (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.createUnboundedVarcharType()))), false);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testDropTableTable() {
        this.metadata.dropTable(SESSION, (ConnectorTableHandle)NUMBERS_TABLE_HANDLE);
    }
}

