/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterConnectorFactory;
import io.hetu.core.plugin.datacenter.DataCenterTable;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.statistics.ColumnStatistics;
import io.prestosql.spi.statistics.DoubleRange;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.testing.TestingTypeManager;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDataCenterClient {
    private TestingPrestoServer server;
    private DataCenterConfig config;
    private OkHttpClient httpClient;
    private URI baseUri;
    private TypeManager typeManager = new TestingTypeManager();

    @BeforeClass
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.baseUri = this.server.getBaseUrl();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
        this.config = new DataCenterConfig().setConnectionUrl(this.baseUri).setConnectionUser("root");
        this.httpClient = DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)this.config);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Test
    public void testShowCatalogs() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        Set catalogNames = client.getCatalogNames();
        Assert.assertTrue((boolean)catalogNames.contains("tpch"));
        Assert.assertEquals((int)catalogNames.size(), (int)2);
    }

    @Test
    public void testShowSchemas() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        Set schemaNames = client.getSchemaNames("tpch");
        Assert.assertTrue((boolean)schemaNames.contains("tiny"));
        Assert.assertEquals((int)schemaNames.size(), (int)9);
    }

    @Test
    public void testShowTables() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        Set tableNames = client.getTableNames("tpch", "tiny");
        Assert.assertTrue((boolean)tableNames.contains("orders"));
        Assert.assertEquals((int)tableNames.size(), (int)8);
    }

    @Test
    public void testGetTable() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        DataCenterTable table = client.getTable("tpch", "tiny", "orders");
        Assert.assertTrue((boolean)table.getColumns().contains(new DataCenterColumn("orderkey", (Type)BigintType.BIGINT)));
        Assert.assertEquals((int)table.getColumns().size(), (int)9);
    }

    @Test
    public void testGetColumns() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        List columns = client.getColumns("select * from tpch.tiny.orders");
        Assert.assertTrue((boolean)columns.contains(new DataCenterColumn("orderkey", (Type)BigintType.BIGINT)));
        Assert.assertEquals((int)columns.size(), (int)9);
    }

    @Test
    public void testGetTableStatistics() {
        LinkedHashMap<String, DataCenterColumnHandle> columnHandles = new LinkedHashMap<String, DataCenterColumnHandle>();
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        columnHandles.put("orderkey", new DataCenterColumnHandle("orderkey", (Type)DoubleType.DOUBLE, 0));
        columnHandles.put("custkey", new DataCenterColumnHandle("custkey", (Type)DoubleType.DOUBLE, 1));
        columnHandles.put("orderstatus", new DataCenterColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1), 2));
        columnHandles.put("totalprice", new DataCenterColumnHandle("totalprice", (Type)DoubleType.DOUBLE, 3));
        columnHandles.put("orderdate", new DataCenterColumnHandle("orderdate", (Type)DateType.DATE, 4));
        columnHandles.put("orderpriority", new DataCenterColumnHandle("orderpriority", (Type)VarcharType.createVarcharType((int)15), 5));
        columnHandles.put("clerk", new DataCenterColumnHandle("clerk", (Type)VarcharType.createUnboundedVarcharType(), 6));
        columnHandles.put("shippriority", new DataCenterColumnHandle("shippriority", (Type)DoubleType.DOUBLE, 7));
        columnHandles.put("comment", new DataCenterColumnHandle("comment", (Type)VarcharType.createVarcharType((int)79), 8));
        TableStatistics tableStatistics = client.getTableStatistics("tpch.tiny.orders", columnHandles);
        Assert.assertEquals((Object)tableStatistics.getRowCount().getValue(), (Object)15000.0);
        Map columnStatistics = tableStatistics.getColumnStatistics();
        for (Map.Entry columnstatistics : columnStatistics.entrySet()) {
            ColumnHandle columnhandleKey = (ColumnHandle)columnstatistics.getKey();
            ColumnStatistics columnhandleValue = (ColumnStatistics)columnstatistics.getValue();
            if (columnhandleKey.getColumnName().equals("orderkey")) {
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)15000.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMin(), (Object)1.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMax(), (Object)60000.0);
            }
            if (columnhandleKey.getColumnName().equals("custkey")) {
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)1000.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMin(), (Object)1.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMax(), (Object)1499.0);
            }
            if (columnhandleKey.getColumnName().equals("orderstatus")) {
                Assert.assertEquals((Object)columnhandleValue.getDataSize().getValue(), (Object)3.0);
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)3.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
            }
            if (columnhandleKey.getColumnName().equals("totalprice")) {
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)14996.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMin(), (Object)874.89);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMax(), (Object)466001.28);
            }
            if (columnhandleKey.getColumnName().equals("orderdate")) {
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)2401.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMin(), (Object)8035.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMax(), (Object)10440.0);
            }
            if (columnhandleKey.getColumnName().equals("orderpriority")) {
                Assert.assertEquals((Object)columnhandleValue.getDataSize().getValue(), (Object)42.0);
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)5.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
            }
            if (columnhandleKey.getColumnName().equals("clerk")) {
                Assert.assertEquals((Object)columnhandleValue.getDataSize().getValue(), (Object)15000.0);
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)1000.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
            }
            if (columnhandleKey.getColumnName().equals("shippriority")) {
                Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)1.0);
                Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMin(), (Object)0.0);
                Assert.assertEquals((Object)((DoubleRange)columnhandleValue.getRange().get()).getMax(), (Object)0.0);
            }
            if (!columnhandleKey.getColumnName().equals("comment")) continue;
            Assert.assertEquals((Object)columnhandleValue.getDataSize().getValue(), (Object)727249.0);
            Assert.assertEquals((Object)columnhandleValue.getDistinctValuesCount().getValue(), (Object)14995.0);
            Assert.assertEquals((Object)columnhandleValue.getNullsFraction().getValue(), (Object)0.0);
        }
    }

    @Test
    public void testGetSplits() {
        DataCenterClient client = new DataCenterClient(this.config, this.httpClient, this.typeManager);
        int splits = client.getSplits("random-query");
        Assert.assertEquals((int)splits, (int)5);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testPasswordWithoutSSL() {
        DataCenterConfig config = new DataCenterConfig().setConnectionUrl(this.baseUri).setConnectionUser("root").setConnectionPassword("root").setSsl(false);
        DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)config);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testKerberosWithoutSSL() {
        DataCenterConfig config = new DataCenterConfig().setConnectionUrl(this.baseUri).setConnectionUser("root").setKerberosRemoteServiceName("kerberos").setSsl(false);
        DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)config);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testAccessTokenWithoutSSL() {
        DataCenterConfig config = new DataCenterConfig().setConnectionUrl(this.baseUri).setConnectionUser("root").setAccessToken("token").setSsl(false);
        DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)config);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testDataCenterConnectorFactoryFailure() {
        DataCenterConnectorFactory factory = new DataCenterConnectorFactory();
        factory.create("catalog", Collections.emptyMap(), null);
    }
}

