/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.sql.expression.QualifiedName;
import io.prestosql.spi.sql.expression.Selection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BaseFunctionUtil {
    private BaseFunctionUtil() {
    }

    public static String formatIdentifier(Optional<Map<String, Selection>> qualifiedNames, String identifier) {
        if (qualifiedNames.isPresent()) {
            return qualifiedNames.get().get(identifier).getExpression();
        }
        return identifier;
    }

    public static String formatQualifiedName(QualifiedName name) {
        return name.getParts().stream().map(identifier -> BaseFunctionUtil.formatIdentifier(Optional.empty(), identifier)).collect(Collectors.joining("."));
    }

    public static boolean isDefaultFunction(CallExpression callExpression) {
        CatalogSchemaName catalogSchemaName = callExpression.getFunctionHandle().getFunctionNamespace();
        return CatalogSchemaName.DEFAULT_NAMESPACE.equals((Object)catalogSchemaName);
    }

    public static List<CatalogSchemaName> parserPushDownSupportedRemoteCatalogSchema(String pushDownExternalFunctionNamespaceStr) {
        if (pushDownExternalFunctionNamespaceStr == null) {
            return ImmutableList.of();
        }
        return Arrays.stream(pushDownExternalFunctionNamespaceStr.split("\\|")).map(str -> {
            String[] catalogSchema = str.trim().split("\\.");
            if (catalogSchema.length != 2) {
                throw new IllegalArgumentException("Wrong config value, must contain catalog.schema");
            }
            return new CatalogSchemaName(catalogSchema[0], catalogSchema[1]);
        }).collect(Collectors.toList());
    }

    public static Optional<CatalogSchemaName> parserExternalFunctionCatalogSchema(String connectorRegistryFunctionNamespace) {
        if (connectorRegistryFunctionNamespace == null) {
            return Optional.empty();
        }
        String[] catalogSchema = connectorRegistryFunctionNamespace.trim().split("\\.");
        if (catalogSchema.length != 2) {
            throw new IllegalArgumentException("Wrong config value, must contain catalog.schema");
        }
        return Optional.of(new CatalogSchemaName(catalogSchema[0], catalogSchema[1]));
    }
}

