/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.splitmanager.DataSourceTableSplitManager;
import io.prestosql.plugin.splitmanager.TableSplitConfig;
import io.prestosql.spi.connector.ConnectorSession;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TableSplitFieldCheck
extends ForwardingJdbcClient {
    private final JdbcClient delegate;
    private final DataSourceTableSplitManager tableSplitManager;
    private static final List<Integer> SPLITFIELD_SUPPORT_JDBC_TYPE = Arrays.asList(-6, 5, 4, -5);

    public TableSplitFieldCheck(JdbcClient delegate, DataSourceTableSplitManager tableSplitManager) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.tableSplitManager = Objects.requireNonNull(tableSplitManager, "tableSplitManager is null");
    }

    @Override
    protected JdbcClient getDelegate() {
        return this.delegate;
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        List<JdbcColumnHandle> columnHandleList = this.getDelegate().getColumns(session, tableHandle);
        TableSplitConfig config = this.tableSplitManager.getTableSplitConfig(tableHandle);
        if (config != null && !config.isTableSplitFieldValid()) {
            String tableSplitField = config.getSplitField();
            long matchCoutn = columnHandleList.stream().filter(columnHandle -> {
                int jdbcType = columnHandle.getJdbcTypeHandle().getJdbcType();
                if (!SPLITFIELD_SUPPORT_JDBC_TYPE.contains(jdbcType)) {
                    return false;
                }
                return columnHandle.getColumnName().equals(tableSplitField);
            }).count();
            if (1L == matchCoutn) {
                config.setTableSplitFieldValid(true);
            }
        }
        return columnHandleList;
    }
}

