/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.connector.UpdatablePageSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class JdbcUpdatablePageSource
implements UpdatablePageSource {
    private final ConnectorSession session;
    private final RecordPageSource inner;
    private final ConnectorTableHandle handle;
    private final JdbcClient jdbcClient;
    private final JdbcSplit jdbcSplit;
    private final Connection connection;
    private final int batchSizeLimit = 1000;
    private boolean dmlStatementsCommittedAsAnTransaction;

    public JdbcUpdatablePageSource(RecordSet recordSet, ConnectorSession session, ConnectorTableHandle handle, JdbcClient jdbcClient, BaseJdbcConfig config, JdbcSplit jdbcSplit) {
        this.inner = new RecordPageSource(recordSet);
        this.session = session;
        this.handle = handle;
        this.jdbcClient = jdbcClient;
        this.jdbcSplit = jdbcSplit;
        this.dmlStatementsCommittedAsAnTransaction = config.isDmlStatementsCommitInATransaction();
        try {
            this.connection = jdbcClient.getConnection(JdbcIdentity.from(session), jdbcSplit);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void deleteRows(Block rowIds) {
        try {
            int batchSize = 0;
            boolean autoCommitFlag = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement(this.jdbcClient.buildDeleteSql(this.handle));){
                for (int position = 0; position < rowIds.getPositionCount(); ++position) {
                    this.jdbcClient.setDeleteSql(statement, rowIds, position);
                    statement.addBatch();
                    if (++batchSize < 1000) continue;
                    statement.executeBatch();
                    batchSize = 0;
                    if (this.dmlStatementsCommittedAsAnTransaction) continue;
                    this.connection.commit();
                    this.connection.setAutoCommit(false);
                }
                if (batchSize > 0) {
                    statement.executeBatch();
                }
                if (this.dmlStatementsCommittedAsAnTransaction || batchSize > 0) {
                    this.connection.commit();
                }
                this.connection.setAutoCommit(autoCommitFlag);
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void updateRows(Page page, List<Integer> columnValueAndRowIdChannels, List<String> updatedColumns) {
        try {
            List<Block> columnValueAndRowIdBlock = columnValueAndRowIdChannels.stream().map(index -> page.getBlock(index.intValue())).collect(Collectors.toList());
            Block rowIds = (Block)columnValueAndRowIdBlock.get(columnValueAndRowIdBlock.size() - 1);
            boolean autoCommitFlag = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement(this.jdbcClient.buildUpdateSql(this.session, this.handle, updatedColumns.size(), updatedColumns));){
                int batchSize = 0;
                for (int position = 0; position < rowIds.getPositionCount(); ++position) {
                    this.jdbcClient.setUpdateSql(this.session, this.handle, statement, columnValueAndRowIdBlock, position, updatedColumns);
                    statement.addBatch();
                    if (++batchSize < 1000) continue;
                    statement.executeBatch();
                    batchSize = 0;
                    if (this.dmlStatementsCommittedAsAnTransaction) continue;
                    this.connection.commit();
                    this.connection.setAutoCommit(false);
                }
                if (batchSize > 0) {
                    statement.executeBatch();
                }
                if (this.dmlStatementsCommittedAsAnTransaction || batchSize > 0) {
                    this.connection.commit();
                }
                this.connection.setAutoCommit(autoCommitFlag);
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public long getCompletedBytes() {
        return this.inner.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.inner.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.inner.isFinished();
    }

    public Page getNextPage() {
        return this.inner.getNextPage();
    }

    public long getSystemMemoryUsage() {
        return this.inner.getSystemMemoryUsage();
    }

    public void close() throws IOException {
        this.inner.close();
    }

    public CompletableFuture<Collection<Slice>> finish() {
        CompletableFuture<Collection<Slice>> cf = new CompletableFuture<Collection<Slice>>();
        cf.complete(Collections.emptyList());
        return cf;
    }

    public void abort() {
        try (Connection connection = this.connection;){
            if (!connection.isClosed()) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }
}

