/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client.protocol;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.prestosql.client.Column;
import io.prestosql.client.util.TypeUtil;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class DataCenterRowIterable
implements Iterable<List<Object>> {
    private final ConnectorSession session;
    private final List<Column> columns;
    private final Page page;
    private final TypeManager typeManager;

    public DataCenterRowIterable(ConnectorSession session, List<Column> columns, Page page, TypeManager typeManager) {
        this.session = session;
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "types is null"));
        this.page = Objects.requireNonNull(page, "page is null");
        this.typeManager = typeManager;
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new DataCenterRowIterator(this.session, this.columns, this.page, this.typeManager);
    }

    private static class DataCenterRowIterator
    extends AbstractIterator<List<Object>> {
        private final ConnectorSession session;
        private final List<Column> columns;
        private final Page page;
        private int position = -1;
        private TypeManager typeManager;

        private DataCenterRowIterator(ConnectorSession session, List<Column> columns, Page page, TypeManager typeManager) {
            this.session = session;
            this.columns = columns;
            this.page = page;
            this.typeManager = typeManager;
        }

        protected List<Object> computeNext() {
            ++this.position;
            if (this.position >= this.page.getPositionCount()) {
                return (List)this.endOfData();
            }
            ArrayList<Object> values = new ArrayList<Object>(this.page.getChannelCount());
            for (int channel = 0; channel < this.page.getChannelCount(); ++channel) {
                String typeStr = this.columns.get(channel).getType().toLowerCase(Locale.ENGLISH);
                Type type = TypeUtil.parseType(this.typeManager, typeStr);
                Block block = this.page.getBlock(channel);
                values.add(type.getObjectValue(this.session, block, this.position));
            }
            return Collections.unmodifiableList(values);
        }
    }
}

