/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.expressions;

import io.prestosql.expressions.RowExpressionRewriter;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.ConstantExpression;
import io.prestosql.spi.relation.InputReferenceExpression;
import io.prestosql.spi.relation.LambdaDefinitionExpression;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.relation.RowExpressionVisitor;
import io.prestosql.spi.relation.SpecialForm;
import io.prestosql.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RowExpressionTreeRewriter<C> {
    private final RowExpressionRewriter<C> rewriter;
    private final RowExpressionVisitor<RowExpression, Context<C>> visitor;

    public static <C, T extends RowExpression> T rewriteWith(RowExpressionRewriter<C> rewriter, T node) {
        return new RowExpressionTreeRewriter<Object>(rewriter).rewrite(node, null);
    }

    public static <C, T extends RowExpression> T rewriteWith(RowExpressionRewriter<C> rewriter, T node, C context) {
        return new RowExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public RowExpressionTreeRewriter(RowExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    private List<RowExpression> rewrite(List<RowExpression> items, Context<C> context) {
        ArrayList<RowExpression> rewritenExpressions = new ArrayList<RowExpression>();
        for (RowExpression expression : items) {
            rewritenExpressions.add(this.rewrite(expression, context.get()));
        }
        return Collections.unmodifiableList(rewritenExpressions);
    }

    public <T extends RowExpression> T rewrite(T node, C context) {
        return (T)((RowExpression)node.accept(this.visitor, new Context(context, false)));
    }

    public <T extends RowExpression> T defaultRewrite(T node, C context) {
        return (T)((RowExpression)node.accept(this.visitor, new Context(context, true)));
    }

    private static <T> boolean sameElements(Collection<? extends T> a, Collection<? extends T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    implements RowExpressionVisitor<RowExpression, Context<C>> {
        private RewritingVisitor() {
        }

        public RowExpression visitInputReference(InputReferenceExpression input, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteInputReference(input, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return input;
        }

        public RowExpression visitCall(CallExpression call, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteCall(call, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = RowExpressionTreeRewriter.this.rewrite((RowExpression)call.getArguments(), (Object)context);
            if (!RowExpressionTreeRewriter.sameElements(call.getArguments(), arguments)) {
                return new CallExpression(call.getDisplayName(), call.getFunctionHandle(), call.getType(), arguments, call.getFilter());
            }
            return call;
        }

        public RowExpression visitConstant(ConstantExpression literal, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteConstant(literal, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteLambda(lambda, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            RowExpression body = RowExpressionTreeRewriter.this.rewrite(lambda.getBody(), context.get());
            if (body != lambda.getBody()) {
                return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), body);
            }
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression variable, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteVariableReference(variable, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return variable;
        }

        public RowExpression visitSpecialForm(SpecialForm specialForm, Context<C> context) {
            RowExpression result;
            if (!context.isDefaultRewrite() && (result = RowExpressionTreeRewriter.this.rewriter.rewriteSpecialForm(specialForm, context.get(), RowExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = RowExpressionTreeRewriter.this.rewrite((RowExpression)specialForm.getArguments(), (Object)context);
            if (!RowExpressionTreeRewriter.sameElements(specialForm.getArguments(), arguments)) {
                return new SpecialForm(specialForm.getForm(), specialForm.getType(), arguments);
            }
            return specialForm;
        }
    }
}

