/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AssignmentItem;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Update
extends Statement {
    private final Table table;
    private final List<AssignmentItem> assignmentItems;
    private final Optional<Expression> where;

    public Update(Table table, List<AssignmentItem> assignmentItems, Optional<Expression> where) {
        this(Optional.empty(), table, assignmentItems, where);
    }

    public Update(NodeLocation location, Table table, List<AssignmentItem> assignmentItems, Optional<Expression> where) {
        this(Optional.of(location), table, assignmentItems, where);
    }

    private Update(Optional<NodeLocation> location, Table table, List<AssignmentItem> assignmentItems, Optional<Expression> where) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.assignmentItems = Objects.requireNonNull(assignmentItems, "assignmentItems is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public List<AssignmentItem> getAssignmentItems() {
        return this.assignmentItems;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdate(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.table);
        nodes.add((Object)((Node)((Object)this.assignmentItems)));
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.assignmentItems, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Update o = (Update)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.assignmentItems, o.assignmentItems) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("assignmentItems", this.assignmentItems).add("where", this.where).toString();
    }
}

