/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InsertCube
extends Statement {
    private final QualifiedName cubeName;
    private final Optional<Expression> where;
    private final List<Identifier> columns;
    private final Query query;
    private final boolean overwrite;

    public InsertCube(QualifiedName cubeName, Optional<Expression> where, boolean overwrite) {
        this(cubeName, where, null, overwrite);
    }

    public InsertCube(NodeLocation location, QualifiedName cubeName, Optional<Expression> where, boolean overwrite) {
        this(location, cubeName, where, null, overwrite);
    }

    public InsertCube(QualifiedName cubeName, Optional<Expression> where, List<Identifier> columns, boolean overwrite) {
        this(cubeName, where, columns, overwrite, null);
    }

    public InsertCube(NodeLocation location, QualifiedName cubeName, Optional<Expression> where, List<Identifier> columns, boolean overwrite) {
        this(location, cubeName, where, columns, overwrite, null);
    }

    public InsertCube(QualifiedName cubeName, Optional<Expression> where, List<Identifier> columns, boolean overwrite, Query query) {
        super(Optional.empty());
        this.cubeName = cubeName;
        this.where = where;
        this.columns = columns;
        this.overwrite = overwrite;
        this.query = query;
    }

    public InsertCube(NodeLocation location, QualifiedName cubeName, Optional<Expression> where, List<Identifier> columns, boolean overwrite, Query query) {
        super(Optional.of(location));
        this.cubeName = cubeName;
        this.where = where;
        this.columns = columns;
        this.overwrite = overwrite;
        this.query = query;
    }

    public QualifiedName getCubeName() {
        return this.cubeName;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public List<Identifier> getColumns() {
        return this.columns;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertCube(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cubeName, this.where);
    }

    @Override
    public String toString() {
        return "InsertCube{cubeName=" + this.cubeName + ", where=" + this.where + ", columns=" + this.columns + ", query=" + this.query + ", overwrite=" + this.overwrite + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsertCube o = (InsertCube)obj;
        return Objects.equals(this.cubeName, o.cubeName) && Objects.equals(this.where, o.where) && Objects.equals(this.overwrite, o.overwrite);
    }
}

