/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropCache
extends Statement {
    private final QualifiedName tableName;
    private final boolean exists;
    private final Optional<Expression> where;

    public DropCache(QualifiedName tableName, boolean exists) {
        this(Optional.empty(), tableName, exists, Optional.empty());
    }

    public DropCache(NodeLocation location, QualifiedName tableName, boolean exists, Optional<Expression> where) {
        this(Optional.of(location), tableName, exists, where);
    }

    private DropCache(Optional<NodeLocation> location, QualifiedName tableName, boolean exists, Optional<Expression> where) {
        super(location);
        this.tableName = tableName;
        this.exists = exists;
        this.where = where;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropCache(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropCache o = (DropCache)obj;
        return Objects.equals(this.tableName, o.tableName) && this.exists == o.exists && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("exists", this.exists).add("where", (Object)(this.where.isPresent() ? this.where.get().toString() : "null")).toString();
    }
}

