/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SelectItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AllColumns
extends SelectItem {
    private final Optional<QualifiedName> prefix;

    public AllColumns() {
        super(Optional.empty());
        this.prefix = Optional.empty();
    }

    public AllColumns(NodeLocation location) {
        super(Optional.of(location));
        this.prefix = Optional.empty();
    }

    public AllColumns(QualifiedName prefix) {
        this(Optional.empty(), prefix);
    }

    public AllColumns(NodeLocation location, QualifiedName prefix) {
        this(Optional.of(location), prefix);
    }

    private AllColumns(Optional<NodeLocation> location, QualifiedName prefix) {
        super(location);
        Objects.requireNonNull(prefix, "prefix is null");
        this.prefix = Optional.of(prefix);
    }

    public Optional<QualifiedName> getPrefix() {
        return this.prefix;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAllColumns(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllColumns that = (AllColumns)o;
        return Objects.equals(this.prefix, that.prefix);
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode();
    }

    @Override
    public String toString() {
        if (this.prefix.isPresent()) {
            return this.prefix.get() + ".*";
        }
        return "*";
    }
}

