/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall;

import com.google.common.base.Joiner;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.optimization.BaseJdbcRowExpressionConverter;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.function.SqlFunctionHandle;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.RowExpressionVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ApplyRemoteFunctionPushDown {
    private final String connectorName;
    private final BaseJdbcConfig baseJdbcConfig;
    private final List<CatalogSchemaName> supportedCatalogSchemaPrefixList;

    public ApplyRemoteFunctionPushDown(BaseJdbcConfig baseJdbcConfig, String connectorName) {
        this.baseJdbcConfig = Objects.requireNonNull(baseJdbcConfig, "baseJdbcConfig if null");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.supportedCatalogSchemaPrefixList = baseJdbcConfig.getPushDownExternalFunctionNamespace();
    }

    public Optional<String> rewriteRemoteFunction(CallExpression callExpression, BaseJdbcRowExpressionConverter rowExpressionConverter, JdbcConverterContext jdbcConverterContext) {
        if (!this.isConnectorSupportedRemoteFunction(callExpression)) {
            return Optional.empty();
        }
        jdbcConverterContext.setRemoteUdfVisited(true);
        String displayName = ((SqlFunctionHandle)callExpression.getFunctionHandle()).getFunctionId().getFunctionName().getObjectName();
        String args = Joiner.on((String)",").join((Iterable)callExpression.getArguments().stream().map(expression -> (String)expression.accept((RowExpressionVisitor)rowExpressionConverter, (Object)jdbcConverterContext)).collect(Collectors.toList()));
        return Optional.of(String.format("%s(%s)", displayName, args));
    }

    protected final boolean isConnectorSupportedRemoteFunction(CallExpression callExpression) {
        if (callExpression == null) {
            return false;
        }
        CatalogSchemaName catalogSchemaName = callExpression.getFunctionHandle().getFunctionNamespace();
        for (CatalogSchemaName catalogSchemaPrefix : this.supportedCatalogSchemaPrefixList) {
            if (!catalogSchemaName.equals((Object)catalogSchemaPrefix)) continue;
            return true;
        }
        return false;
    }
}

