/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DataSourceSplitSource
implements ConnectorSplitSource {
    private final List<ConnectorSplit> splits;
    private int offset;

    public DataSourceSplitSource(Iterable<? extends ConnectorSplit> splits) {
        if (splits == null) {
            throw new NullPointerException("splits is null");
        }
        ArrayList<ConnectorSplit> splitsList = new ArrayList<ConnectorSplit>();
        for (ConnectorSplit connectorSplit : splits) {
            splitsList.add(connectorSplit);
        }
        this.splits = Collections.unmodifiableList(splitsList);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        int remainingSplits = this.splits.size() - this.offset;
        int size = Math.min(remainingSplits, maxSize);
        List<ConnectorSplit> results = this.splits.subList(this.offset, this.offset + size);
        this.offset += size;
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(results, this.isFinished()));
    }

    public boolean isFinished() {
        return this.offset >= this.splits.size();
    }

    public void close() {
    }
}

