/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.splitmanager.DataSourceTableSplitManager;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcSplitManager
implements ConnectorSplitManager {
    private final JdbcClient jdbcClient;
    private boolean tableSplitEnable;
    private DataSourceTableSplitManager tableSplitManager;

    @Inject
    public JdbcSplitManager(@InternalBaseJdbc JdbcClient jdbcClient, BaseJdbcConfig config, DataSourceTableSplitManager tableSplitManager) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
        this.tableSplitEnable = Objects.requireNonNull(config, "config is null").getTableSplitEnable();
        this.tableSplitManager = Objects.requireNonNull(tableSplitManager, "tableSplitManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        if (this.tableSplitEnable && !tableHandle.getGeneratedSql().isPresent()) {
            return this.tableSplitManager.getSplits(JdbcIdentity.from(session), tableHandle);
        }
        return this.jdbcClient.getSplits(JdbcIdentity.from(session), tableHandle);
    }
}

