/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import com.google.common.base.Strings;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.splitmanager.DataSourceTableSplitManager;
import io.prestosql.plugin.splitmanager.TableSplitConfig;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableSplitFieldCheck
extends ForwardingJdbcClient {
    private final JdbcClient delegate;
    private final DataSourceTableSplitManager tableSplitManager;
    private static final List<Integer> SPLITFIELD_SUPPORT_JDBC_TYPE = Arrays.asList(-6, 5, 4, -5);

    public TableSplitFieldCheck(JdbcClient delegate, DataSourceTableSplitManager tableSplitManager) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.tableSplitManager = Objects.requireNonNull(tableSplitManager, "tableSplitManager is null");
    }

    @Override
    protected JdbcClient getDelegate() {
        return this.delegate;
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity identity, SchemaTableName schemaTableName) {
        TableSplitConfig config;
        Optional<JdbcTableHandle> tableHandle = this.getDelegate().getTableHandle(identity, schemaTableName);
        if (tableHandle.isPresent() && null != (config = this.tableSplitManager.getTableSplitConfig(tableHandle.get()))) {
            tableHandle.get().setTableSplitField(config.getSplitField());
        }
        return tableHandle;
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        long matchCoutn;
        List<JdbcColumnHandle> columnHandleList = this.getDelegate().getColumns(session, tableHandle);
        String tableSplitField = tableHandle.getTableSplitField();
        if (!Strings.isNullOrEmpty((String)tableSplitField) && 1L == (matchCoutn = columnHandleList.stream().filter(columnHandle -> {
            int jdbcType = columnHandle.getJdbcTypeHandle().getJdbcType();
            if (!SPLITFIELD_SUPPORT_JDBC_TYPE.contains(jdbcType)) {
                return false;
            }
            return columnHandle.getColumnName().equals(tableSplitField);
        }).count())) {
            tableHandle.setTableSplitFieldValidated(true);
        }
        return columnHandleList;
    }
}

