/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import io.prestosql.plugin.splitmanager.TableSplitUtil;
import java.util.Objects;

public class TableSplitConfig
implements Comparable<TableSplitConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String splitField;
    private boolean isCalcStepEnable;
    private boolean isDataReadOnly;
    private Integer scanNodes;
    private Long fieldMinValue;
    private Long fieldMaxValue;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public boolean isDataReadOnly() {
        return this.isDataReadOnly;
    }

    public void setDataReadOnly(boolean dataReadOnly) {
        this.isDataReadOnly = dataReadOnly;
    }

    public boolean isCalcStepEnable() {
        return this.isCalcStepEnable;
    }

    public void setCalcStepEnable(boolean calcStepEnable) {
        this.isCalcStepEnable = calcStepEnable;
    }

    public Integer getSplitCount() {
        return this.scanNodes;
    }

    public void setSplitCount(Integer scanNodes) {
        this.scanNodes = scanNodes;
    }

    public Long getFieldMinValue() {
        return this.fieldMinValue;
    }

    public void setFieldMinValue(Long fieldMinValue) {
        this.fieldMinValue = fieldMinValue;
    }

    public Long getFieldMaxValue() {
        return this.fieldMaxValue;
    }

    public void setFieldMaxValue(Long fieldMaxValue) {
        this.fieldMaxValue = fieldMaxValue;
    }

    @Override
    public int compareTo(TableSplitConfig o) {
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    public int hashCode() {
        return Objects.hashCode(TableSplitUtil.generateTableFullName(this.catalogName, this.schemaName, this.tableName));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSplitConfig)) {
            return false;
        }
        TableSplitConfig other = (TableSplitConfig)obj;
        return this.hashCode() == other.hashCode();
    }
}

