/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import com.google.common.base.Preconditions;
import io.airlift.concurrent.SetThreadName;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.splitmanager.SplitStatLog;
import io.prestosql.plugin.splitmanager.TableSplitConfig;
import io.prestosql.plugin.splitmanager.TableSplitUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class StepCalcManager
implements Runnable {
    private static final Logger log = Logger.get(StepCalcManager.class);
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"step-calc-processor-%d"));
    private final ThreadPoolExecutorMBean executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
    private PriorityBlockingQueue<TableSplitConfig> adjustTableQueue;
    private static final AtomicLong NEXT_RUNNER_ID = new AtomicLong();
    private volatile boolean closed;
    private final int stepCalcThreads;
    private Duration refreshInterval;
    private long lastUpdateTime;
    private ConcurrentHashMap<String, TableSplitConfig> tableList;
    private ConcurrentHashMap<String, List<SplitStatLog>> splitRunLog;
    private ConcurrentHashMap<String, List<SplitStatLog>> splitAdjustLog;

    public StepCalcManager(Duration pdboRefreshInverval, int stepCalcThreads, List<TableSplitConfig> tableList) {
        Objects.requireNonNull(tableList, "Table split config list is null.");
        this.tableList = new ConcurrentHashMap();
        for (TableSplitConfig table : tableList) {
            this.tableList.put(TableSplitUtil.generateTableFullName(table.getCatalogName(), table.getSchemaName(), table.getTableName()), table);
        }
        this.adjustTableQueue = new PriorityBlockingQueue(tableList.size() > 0 ? tableList.size() * 2 : 10);
        this.closed = false;
        this.lastUpdateTime = 0L;
        this.refreshInterval = pdboRefreshInverval;
        this.stepCalcThreads = stepCalcThreads;
        this.splitRunLog = new ConcurrentHashMap();
        this.splitAdjustLog = new ConcurrentHashMap();
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                if (this.lastUpdateTime == 0L) {
                    this.addTableInfo();
                } else {
                    Thread.sleep(this.refreshInterval.toMillis());
                    this.addTableInfo();
                }
                this.lastUpdateTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                log.error("Load pdbo table error : ", new Object[]{e.getMessage()});
                this.lastUpdateTime = System.currentTimeMillis();
            }
        }
    }

    public void addTableInfo() {
        if (this.adjustTableQueue.isEmpty()) {
            ArrayList<TableSplitConfig> configList = new ArrayList<TableSplitConfig>();
            for (Map.Entry<String, TableSplitConfig> entry : this.tableList.entrySet()) {
                configList.add(entry.getValue());
            }
            this.startSplit(configList);
        }
    }

    public void updateTableConfig(List<TableSplitConfig> configList) {
        Objects.requireNonNull(configList, "Table split config list is null.");
        this.tableList = new ConcurrentHashMap();
        for (TableSplitConfig table : configList) {
            this.tableList.put(TableSplitUtil.generateTableFullName(table.getCatalogName(), table.getSchemaName(), table.getTableName()), table);
        }
    }

    private static List<SplitStatLog> copySplitStatLogList(List<SplitStatLog> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<SplitStatLog> copyLogList = new ArrayList<SplitStatLog>();
        for (SplitStatLog statLog : list) {
            SplitStatLog log = new SplitStatLog();
            log.setCatalogName(statLog.getCatalogName()).setSchemaName(statLog.getSchemaName()).setTableName(statLog.getTableName()).setSplitField(statLog.getSplitField()).setSplitCount(statLog.getSplitCount()).setRows(statLog.getRows()).setBeginIndex(statLog.getBeginIndex()).setEndIndex(statLog.getEndIndex()).setTimeStamp(statLog.getTimeStamp()).setRecordFlag(statLog.getRecordFlag());
            copyLogList.add(log);
        }
        return copyLogList;
    }

    public void commitSplitStatLog(List<SplitStatLog> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List<SplitStatLog> runLogList = StepCalcManager.copySplitStatLogList(list);
        Collections.sort(runLogList, new Comparator<SplitStatLog>(){

            @Override
            public int compare(SplitStatLog splitStatLog, SplitStatLog t1) {
                return splitStatLog.getBeginIndex() > t1.getBeginIndex() ? 1 : -1;
            }
        });
        SplitStatLog firstLog = runLogList.get(0);
        TableSplitConfig table = this.tableList.get(TableSplitUtil.generateTableFullName(firstLog.getCatalogName(), firstLog.getSchemaName(), firstLog.getTableName()));
        if (table == null || !StepCalcManager.checkSplitLog(table, runLogList).booleanValue()) {
            return;
        }
        String key = TableSplitUtil.generateTableFullName(firstLog.getCatalogName(), firstLog.getSchemaName(), firstLog.getTableName());
        this.splitRunLog.remove(key);
        this.splitRunLog.put(key, runLogList);
    }

    private synchronized void startSplit(List<TableSplitConfig> tables) {
        this.adjustTableQueue.addAll(tables);
    }

    @PostConstruct
    public synchronized void start() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"StepCalcManager is closed");
        for (int i = 0; i < this.stepCalcThreads; ++i) {
            this.addRunnerThread(new AdjustRunner());
        }
    }

    @PreDestroy
    public synchronized void stop() {
        this.closed = true;
        this.executor.shutdownNow();
    }

    private synchronized void addRunnerThread(Runnable runner) {
        try {
            this.executor.execute(runner);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public List<SplitStatLog> getAdjustSplitList(String catalogName, String schemaName, String tableName) {
        String key = TableSplitUtil.generateTableFullName(catalogName, schemaName, tableName);
        List<SplitStatLog> result = this.splitAdjustLog.get(key);
        List<SplitStatLog> resultLogList = null;
        if (result != null) {
            resultLogList = StepCalcManager.copySplitStatLogList(result);
        }
        return resultLogList;
    }

    public static List<SplitStatLog> stepCalcProc(TableSplitConfig table, List<SplitStatLog> tableLogList) {
        Boolean successed = false;
        List<SplitStatLog> tableLogs = StepCalcManager.copySplitStatLogList(tableLogList);
        Collections.sort(tableLogs, new Comparator<SplitStatLog>(){

            @Override
            public int compare(SplitStatLog splitStatLog, SplitStatLog t1) {
                return splitStatLog.getBeginIndex() > t1.getBeginIndex() ? 1 : -1;
            }
        });
        if (!StepCalcManager.checkSplitLog(table, tableLogs).booleanValue()) {
            return null;
        }
        ArrayList<SplitStatLog> result = new ArrayList<SplitStatLog>();
        successed = StepCalcManager.adjustTableSplit(tableLogs, result);
        if (successed.booleanValue()) {
            SplitStatLog firstLog = tableLogs.get(0);
            for (SplitStatLog statLog : result) {
                statLog.setSplitField(firstLog.getSplitField()).setRecordFlag(SplitStatLog.LogState.STATE_FINISH);
            }
        } else {
            result.clear();
            return null;
        }
        return result;
    }

    private static Boolean checkSplitLog(TableSplitConfig table, List<SplitStatLog> tableLogs) {
        int totalSplitNum = tableLogs.size();
        SplitStatLog firstLog = tableLogs.get(0);
        if (firstLog.getSplitCount() == null) {
            log.debug("scan node is null, split run log invalid. table=" + table.getTableName());
            return false;
        }
        if (firstLog.getSplitCount() != totalSplitNum && firstLog.getSplitCount() + 2 != totalSplitNum) {
            log.debug("split run log invalid. logCount=" + totalSplitNum + ",expect=" + firstLog.getSplitCount() + ", table=" + table.getTableName());
            return false;
        }
        if (!table.getSplitField().equals(firstLog.getSplitField())) {
            log.debug("split run log invalid. config field=" + table.getSplitField() + ",field in log=" + firstLog.getSplitField() + ", table=" + table.getTableName());
            return false;
        }
        if (!table.getSplitCount().equals(firstLog.getSplitCount())) {
            log.debug("split run log invalid. config scanNode=" + table.getSplitCount() + ",log splitCount=" + firstLog.getSplitCount() + ", table=" + table.getTableName());
            return false;
        }
        if (System.nanoTime() < firstLog.getTimeStamp()) {
            return false;
        }
        long rangeEnd = tableLogs.get(0).getBeginIndex();
        for (SplitStatLog statLog : tableLogs) {
            if (rangeEnd != statLog.getBeginIndex()) {
                log.debug("split run log invalid for range not continous. last end=" + rangeEnd + ",range begin=" + statLog.getBeginIndex() + ", table=" + table.getTableName());
                return false;
            }
            if (statLog.getBeginIndex() >= statLog.getEndIndex()) {
                log.debug("split run log invalid for range invalid. range begin=" + statLog.getBeginIndex() + ",range end=" + statLog.getEndIndex() + ", table=" + table.getTableName());
                return false;
            }
            if (statLog.getRows() < 0L) {
                return false;
            }
            rangeEnd = statLog.getEndIndex();
        }
        return true;
    }

    private static Boolean adjustTableSplit(List<SplitStatLog> tableLogs, List<SplitStatLog> result) {
        ArrayList<SplitStatLog> tmp = new ArrayList<SplitStatLog>();
        long logCount = tableLogs.size();
        int logIndex = 0;
        long sum = 0L;
        long allRows = tableLogs.stream().mapToLong(SplitStatLog::getRows).sum();
        long averageRows = allRows / (long)tableLogs.size();
        if (averageRows <= 0L) {
            return false;
        }
        Long[] fieldRangeValue = StepCalcManager.getSplitLogFieldRange(tableLogs);
        for (SplitStatLog split : tableLogs) {
            ++logIndex;
            if (averageRows > sum + split.getRows()) {
                tmp.add(split);
                sum += split.getRows().longValue();
                if ((long)logIndex != logCount) continue;
                if ((long)result.size() == logCount) {
                    result.get(result.size() - 1).setEndIndex(split.getEndIndex());
                } else {
                    StepCalcManager.combineResult(tmp, result);
                }
                tmp.clear();
                sum = 0L;
                continue;
            }
            Boolean success = StepCalcManager.generateSplit(allRows, fieldRangeValue, averageRows, tmp, split, result);
            if (!success.booleanValue()) {
                return false;
            }
            sum = tmp.stream().mapToLong(SplitStatLog::getRows).sum();
        }
        if (!tmp.isEmpty()) {
            if (result.size() == tableLogs.size()) {
                result.get(result.size() - 1).setEndIndex(tableLogs.get(tableLogs.size() - 1).getEndIndex());
            } else {
                StepCalcManager.combineResult(tmp, result);
            }
        }
        if ((long)result.size() != logCount) {
            log.debug("adjust step failed, origin logsize=" + logCount + ",result logsize=" + result.size() + ",average rows=" + averageRows);
            return false;
        }
        return true;
    }

    private static Long[] getSplitLogFieldRange(List<SplitStatLog> tableLogs) {
        Long[] rangeValue = new Long[2];
        SplitStatLog firstLog = tableLogs.get(0);
        SplitStatLog lastLog = tableLogs.get(tableLogs.size() - 1);
        rangeValue[0] = firstLog.getBeginIndex() == Long.MIN_VALUE ? firstLog.getEndIndex() : firstLog.getBeginIndex();
        rangeValue[1] = lastLog.getEndIndex() == Long.MAX_VALUE ? lastLog.getBeginIndex() : lastLog.getEndIndex();
        return rangeValue;
    }

    private static void combineResult(List<SplitStatLog> tmp, List<SplitStatLog> result) {
        result.add(new SplitStatLog().setCatalogName(tmp.get(0).getCatalogName()).setSchemaName(tmp.get(0).getSchemaName()).setTableName(tmp.get(0).getTableName()).setRows(tmp.stream().mapToLong(SplitStatLog::getRows).sum()).setSplitCount(tmp.get(0).getSplitCount()).setBeginIndex(tmp.get(0).getBeginIndex()).setEndIndex(tmp.get(tmp.size() - 1).getEndIndex()));
    }

    private static Boolean generateSplit(long allRows, Long[] fieldRangeValue, long averageRows, List<SplitStatLog> gatherList, SplitStatLog split, List<SplitStatLog> result) {
        SplitStatLog subSplit;
        long endIndex;
        long beginIndex;
        long cutSteps;
        long sum = 0L;
        long moreRows = 0L;
        long splitOffset = 0L;
        long nowSum = gatherList.stream().mapToLong(SplitStatLog::getRows).sum();
        if (split.getBeginIndex() == Long.MIN_VALUE && split.getRows() >= averageRows) {
            StepCalcManager.splitLowerBoundSplit(allRows, fieldRangeValue, averageRows, gatherList, split, result);
            return true;
        }
        long leftRows = split.getRows();
        splitOffset = split.getBeginIndex();
        if (!gatherList.isEmpty()) {
            moreRows = averageRows - nowSum;
            cutSteps = split.getEndIndex() == Long.MAX_VALUE ? moreRows * (fieldRangeValue[1] - fieldRangeValue[0]) / allRows : moreRows * (split.getEndIndex() - split.getBeginIndex()) / split.getRows();
            cutSteps = cutSteps > 0L ? cutSteps : 1L;
            beginIndex = split.getBeginIndex();
            endIndex = moreRows == split.getRows() ? split.getEndIndex() : split.getBeginIndex() + cutSteps;
            subSplit = new SplitStatLog();
            subSplit.setCatalogName(split.getCatalogName()).setSchemaName(split.getSchemaName()).setTableName(split.getTableName()).setRows(moreRows).setSplitCount(split.getSplitCount()).setBeginIndex(beginIndex).setEndIndex(endIndex).setRecordFlag(SplitStatLog.LogState.STATE_FINISH);
            gatherList.add(subSplit);
            StepCalcManager.combineResult(gatherList, result);
            gatherList.clear();
            splitOffset = endIndex;
            leftRows = split.getRows() - moreRows;
        }
        while (leftRows >= averageRows) {
            subSplit = new SplitStatLog();
            cutSteps = split.getEndIndex() == Long.MAX_VALUE ? averageRows * (fieldRangeValue[1] - fieldRangeValue[0]) / allRows : averageRows * (split.getEndIndex() - split.getBeginIndex()) / split.getRows();
            cutSteps = cutSteps > 0L ? cutSteps : 1L;
            beginIndex = splitOffset;
            long l = endIndex = leftRows == averageRows ? split.getEndIndex() : splitOffset + cutSteps;
            if (endIndex > split.getEndIndex()) {
                return false;
            }
            subSplit.setCatalogName(split.getCatalogName()).setSchemaName(split.getSchemaName()).setTableName(split.getTableName()).setRows(averageRows).setSplitCount(split.getSplitCount()).setBeginIndex(beginIndex).setEndIndex(endIndex).setRecordFlag(SplitStatLog.LogState.STATE_FINISH);
            result.add(subSplit);
            splitOffset += cutSteps;
            leftRows -= averageRows;
        }
        if (leftRows > 0L) {
            split.setRows(leftRows).setBeginIndex(splitOffset);
            if (split.getBeginIndex() >= split.getEndIndex()) {
                return false;
            }
            gatherList.add(split);
        }
        return true;
    }

    private static void splitLowerBoundSplit(long allRows, Long[] fieldRangeValue, long averageRows, List<SplitStatLog> gatherList, SplitStatLog split, List<SplitStatLog> result) {
        SplitStatLog subSplit;
        long endIndex;
        long beginIndex;
        long cutSteps;
        long splitOffset = 0L;
        long leftRows = split.getRows();
        splitOffset = split.getEndIndex();
        long modRows = split.getRows() % averageRows;
        if (modRows != 0L) {
            cutSteps = modRows * (fieldRangeValue[1] - fieldRangeValue[0]) / allRows;
            cutSteps = cutSteps > 0L ? cutSteps : 1L;
            beginIndex = splitOffset - cutSteps;
            endIndex = split.getEndIndex();
            subSplit = new SplitStatLog();
            subSplit.setCatalogName(split.getCatalogName()).setSchemaName(split.getSchemaName()).setTableName(split.getTableName()).setRows(modRows).setSplitCount(split.getSplitCount()).setBeginIndex(beginIndex).setEndIndex(endIndex).setRecordFlag(SplitStatLog.LogState.STATE_FINISH);
            gatherList.clear();
            gatherList.add(subSplit);
            splitOffset = beginIndex;
            leftRows = split.getRows() - modRows;
        }
        while (leftRows >= averageRows) {
            subSplit = new SplitStatLog();
            cutSteps = averageRows * (fieldRangeValue[1] - fieldRangeValue[0]) / allRows;
            cutSteps = cutSteps > 0L ? cutSteps : 1L;
            beginIndex = averageRows == leftRows ? split.getBeginIndex() : splitOffset - cutSteps;
            endIndex = splitOffset;
            subSplit.setCatalogName(split.getCatalogName()).setSchemaName(split.getSchemaName()).setTableName(split.getTableName()).setRows(averageRows).setSplitCount(split.getSplitCount()).setBeginIndex(beginIndex).setEndIndex(endIndex).setRecordFlag(SplitStatLog.LogState.STATE_FINISH);
            result.add(subSplit);
            splitOffset = beginIndex;
            leftRows -= averageRows;
        }
    }

    static /* synthetic */ AtomicLong access$100() {
        return NEXT_RUNNER_ID;
    }

    private class AdjustRunner
    implements Runnable {
        private final long runnerId = StepCalcManager.access$100().getAndIncrement();

        private AdjustRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (SetThreadName runnerName = new SetThreadName("SplitRunner-%s", new Object[]{this.runnerId});){
                while (!StepCalcManager.this.closed && !Thread.currentThread().isInterrupted()) {
                    TableSplitConfig tableSplitConfig;
                    try {
                        tableSplitConfig = (TableSplitConfig)StepCalcManager.this.adjustTableQueue.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (runnerName != null) {
                            if (var2_2 != null) {
                                try {
                                    runnerName.close();
                                }
                                catch (Throwable throwable) {
                                    var2_2.addSuppressed(throwable);
                                }
                            } else {
                                runnerName.close();
                            }
                        }
                        if (!StepCalcManager.this.closed) {
                            StepCalcManager.this.addRunnerThread(new AdjustRunner());
                        }
                        return;
                    }
                    this.stepCalc(tableSplitConfig);
                }
            }
            finally {
                if (!StepCalcManager.this.closed) {
                    StepCalcManager.this.addRunnerThread(new AdjustRunner());
                }
            }
        }

        public void stepCalc(TableSplitConfig table) {
            if (!table.isCalcStepEnable()) {
                String key = TableSplitUtil.generateTableFullName(table.getCatalogName(), table.getSchemaName(), table.getTableName());
                StepCalcManager.this.splitAdjustLog.remove(key);
                return;
            }
            List<SplitStatLog> tableLogs = this.getTableRunningLogs(table);
            if (tableLogs == null || tableLogs.size() == 0) {
                return;
            }
            List<SplitStatLog> calcStepLogList = StepCalcManager.this.getAdjustSplitList(table.getCatalogName(), table.getSchemaName(), table.getTableName());
            if (calcStepLogList != null && !calcStepLogList.isEmpty() && calcStepLogList.get(0).getTimeStamp() > tableLogs.get(0).getTimeStamp()) {
                return;
            }
            List<SplitStatLog> result = StepCalcManager.stepCalcProc(table, tableLogs);
            if (result != null && !result.isEmpty()) {
                this.saveAdjustLogs(result);
            }
        }

        public List<SplitStatLog> getTableRunningLogs(TableSplitConfig tableConfig) {
            String key = TableSplitUtil.generateTableFullName(tableConfig.getCatalogName(), tableConfig.getSchemaName(), tableConfig.getTableName());
            return (List)StepCalcManager.this.splitRunLog.get(key);
        }

        public void saveAdjustLogs(List<SplitStatLog> result) {
            long timestamp = System.nanoTime();
            for (SplitStatLog split : result) {
                split.setTimeStamp(timestamp);
            }
            SplitStatLog firstLog = result.get(0);
            String key = TableSplitUtil.generateTableFullName(firstLog.getCatalogName(), firstLog.getSchemaName(), firstLog.getTableName());
            StepCalcManager.this.splitAdjustLog.remove(key);
            StepCalcManager.this.splitAdjustLog.put(key, result);
        }
    }
}

