/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class JdbcSplit
implements ConnectorSplit {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String splitField;
    private final String rangeStart;
    private final String rangEnd;
    private final long timeStamp;
    private final int scanNodes;
    private final Optional<String> additionalPredicate;

    @JsonCreator
    public JdbcSplit(@JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="splitField") String splitField, @JsonProperty(value="beginIndex") String rangeStart, @JsonProperty(value="endIndex") String rangEnd, @JsonProperty(value="timeStamp") long timeStamp, @JsonProperty(value="scanNodes") int scanNodes, @JsonProperty(value="additionalPredicate") Optional<String> additionalPredicate) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.rangeStart = rangeStart;
        this.rangEnd = rangEnd;
        this.splitField = splitField;
        this.timeStamp = timeStamp;
        this.scanNodes = scanNodes;
        this.additionalPredicate = Objects.requireNonNull(additionalPredicate, "additionalPredicate is null");
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getRangeStart() {
        return this.rangeStart;
    }

    @JsonProperty
    public String getRangEnd() {
        return this.rangEnd;
    }

    @JsonProperty
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @JsonProperty
    public int getSplitCount() {
        return this.scanNodes;
    }

    @JsonProperty
    public Optional<String> getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    @JsonProperty
    public String getSplitField() {
        return this.splitField;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }
}

