/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.parser.CaseInsensitiveStream;
import io.prestosql.sql.parser.DelimiterLexer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public class StatementSplitter {
    private final List<Statement> completeStatements;
    private final String partialStatement;

    public StatementSplitter(String sql) {
        this(sql, (Set<String>)ImmutableSet.of((Object)";"));
    }

    public StatementSplitter(String sql, Set<String> delimiters) {
        Token token;
        TokenSource tokens = StatementSplitter.getLexer(sql, delimiters);
        ImmutableList.Builder list = ImmutableList.builder();
        StringBuilder sb = new StringBuilder();
        while ((token = tokens.nextToken()).getType() != -1) {
            if (token.getType() == 259) {
                String statement = sb.toString().trim();
                if (!statement.isEmpty()) {
                    list.add((Object)new Statement(statement, token.getText()));
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(token.getText());
        }
        this.completeStatements = list.build();
        this.partialStatement = sb.toString().trim();
    }

    public List<Statement> getCompleteStatements() {
        return this.completeStatements;
    }

    public String getPartialStatement() {
        return this.partialStatement;
    }

    public static String squeezeStatement(String sql) {
        Token token;
        TokenSource tokens = StatementSplitter.getLexer(sql, (Set<String>)ImmutableSet.of());
        StringBuilder sb = new StringBuilder();
        while ((token = tokens.nextToken()).getType() != -1) {
            if (token.getType() == 257) {
                sb.append(' ');
                continue;
            }
            sb.append(token.getText());
        }
        return sb.toString().trim();
    }

    public static boolean isEmptyStatement(String sql) {
        Token token;
        TokenSource tokens = StatementSplitter.getLexer(sql, (Set<String>)ImmutableSet.of());
        do {
            if ((token = tokens.nextToken()).getType() != -1) continue;
            return true;
        } while (token.getChannel() == 1);
        return false;
    }

    public static TokenSource getLexer(String sql, Set<String> terminators) {
        Objects.requireNonNull(sql, "sql is null");
        CaseInsensitiveStream stream = new CaseInsensitiveStream((CharStream)new ANTLRInputStream(sql));
        return new DelimiterLexer(stream, terminators);
    }

    public static class Statement {
        private final String statement;
        private final String terminator;

        public Statement(String statement, String terminator) {
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.terminator = Objects.requireNonNull(terminator, "terminator is null");
        }

        public String statement() {
            return this.statement;
        }

        public String terminator() {
            return this.terminator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Statement o = (Statement)obj;
            return Objects.equals(this.statement, o.statement) && Objects.equals(this.terminator, o.terminator);
        }

        public int hashCode() {
            return Objects.hash(this.statement, this.terminator);
        }

        public String toString() {
            return this.statement + this.terminator;
        }
    }
}

