/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterSplit;
import io.hetu.core.plugin.datacenter.GlobalQueryIdGenerator;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Optional;

public class DataCenterSplitManager
implements ConnectorSplitManager {
    private final DataCenterClient client;
    private final GlobalQueryIdGenerator globalQueryIdGenerator;

    public DataCenterSplitManager(DataCenterConfig config, DataCenterClient client) {
        this.client = client;
        this.globalQueryIdGenerator = new GlobalQueryIdGenerator(Optional.ofNullable(config.getRemoteClusterId()));
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        String queryId = this.globalQueryIdGenerator.createId();
        int splitCount = this.client.getSplits(queryId);
        ArrayList<DataCenterSplit> splits = new ArrayList<DataCenterSplit>(splitCount);
        for (int i = 0; i < splitCount; ++i) {
            splits.add(new DataCenterSplit(queryId));
        }
        return new FixedSplitSource(splits);
    }
}

