/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterTable;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Provider;

public final class MetadataUtil {
    public static final JsonCodec<Map<String, List<DataCenterTable>>> CATALOG_CODEC;
    public static final JsonCodec<DataCenterTable> TABLE_CODEC;
    public static final JsonCodec<DataCenterColumnHandle> COLUMN_CODEC;

    private MetadataUtil() {
    }

    static {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TestingTypeDeserializer())));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)objectMapperProvider);
        CATALOG_CODEC = codecFactory.mapJsonCodec(String.class, JsonCodec.listJsonCodec(DataCenterTable.class));
        TABLE_CODEC = codecFactory.jsonCodec(DataCenterTable.class);
        COLUMN_CODEC = codecFactory.jsonCodec(DataCenterColumnHandle.class);
    }

    public static final class TestingTypeDeserializer
    extends FromStringDeserializer<Type> {
        private final Map<String, Type> types = ImmutableMap.of((Object)"boolean", (Object)BooleanType.BOOLEAN, (Object)"bigint", (Object)BigintType.BIGINT, (Object)"integer", (Object)IntegerType.INTEGER, (Object)"double", (Object)DoubleType.DOUBLE, (Object)"varchar", (Object)VarcharType.createUnboundedVarcharType());

        public TestingTypeDeserializer() {
            super(Type.class);
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.types.get(value.toLowerCase(Locale.ENGLISH));
            if (type == null) {
                throw new IllegalArgumentException(String.valueOf("Unknown type " + value));
            }
            return type;
        }
    }
}

