/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.pagesource;

import com.google.common.base.Strings;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterSplit;
import io.hetu.core.plugin.datacenter.DataCenterTableHandle;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.hetu.core.plugin.datacenter.pagesource.DataCenterPageSource;
import io.prestosql.client.DataCenterClientSession;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.type.TypeManager;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;

public class DataCenterPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final int STRING_CAPACITY = 16;
    private static final String ENABLE_CROSS_REGION_DYNAMIC_FILTER = "cross_region_dynamic_filter_enabled";
    private static final String EXCHANGE_COMPRESSION = "exchange_compression";
    private final DataCenterConfig config;
    private final OkHttpClient httpClient;
    private final TypeManager typeManager;

    public DataCenterPageSourceProvider(DataCenterConfig config, OkHttpClient httpClient, TypeManager typeManager) {
        this.config = config;
        this.httpClient = httpClient;
        this.typeManager = typeManager;
    }

    private static String buildSql(DataCenterTableHandle tableHandler, List<ColumnHandle> columnHandles, OptionalLong limit) {
        StringBuilder sql = new StringBuilder(16);
        String catalog = tableHandler.getCatalogName();
        String schema = tableHandler.getSchemaName();
        String table = tableHandler.getTableName();
        String columnNames = columnHandles.stream().map(ColumnHandle::getColumnName).collect(Collectors.joining(", "));
        sql.append("SELECT ");
        sql.append(columnNames);
        if (columnHandles.isEmpty()) {
            sql.append("null");
        }
        sql.append(" FROM ");
        if (tableHandler.getPushDownSql() == null || "".equals(tableHandler.getPushDownSql())) {
            if (!Strings.isNullOrEmpty((String)catalog)) {
                sql.append(catalog).append('.');
            }
            if (!Strings.isNullOrEmpty((String)schema)) {
                sql.append(schema).append('.');
            }
            sql.append(table);
        } else {
            sql.append("(").append(tableHandler.getPushDownSql()).append(") pushdown");
        }
        if (limit.isPresent()) {
            sql.append(" LIMIT ").append(limit.getAsLong());
        }
        return sql.toString();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
        return this.createPageSource(transaction, session, split, table, columns, Optional.empty());
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, Optional<DynamicFilterSupplier> dynamicFilterSupplier) {
        String query = DataCenterPageSourceProvider.buildSql((DataCenterTableHandle)table, columns, ((DataCenterTableHandle)table).getLimit());
        HashMap<String, String> properties = new HashMap<String, String>();
        if (dynamicFilterSupplier != null && dynamicFilterSupplier.isPresent()) {
            properties.put(ENABLE_CROSS_REGION_DYNAMIC_FILTER, "true");
        }
        if (this.config.isCompressionEnabled()) {
            properties.put(EXCHANGE_COMPRESSION, "true");
        }
        DataCenterClientSession clientSession = DataCenterStatementClientFactory.createClientSession(this.config, this.typeManager, properties);
        return new DataCenterPageSource(this.httpClient, clientSession, query, ((DataCenterSplit)split).getQueryId(), columns, dynamicFilterSupplier);
    }
}

