/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CreateCube
extends Statement {
    private final QualifiedName cubeName;
    private final boolean notExists;
    private final QualifiedName sourceTableName;
    private final List<Identifier> groupingSet;
    private final Set<FunctionCall> aggregations;
    private final List<Property> properties;

    public CreateCube(QualifiedName cubeName, QualifiedName sourceTableName, List<Identifier> groupingSet, Set<FunctionCall> aggregations, boolean notExists, List<Property> properties) {
        this(Optional.empty(), cubeName, sourceTableName, groupingSet, aggregations, notExists, properties);
    }

    public CreateCube(NodeLocation location, QualifiedName cubeName, QualifiedName sourceTableName, List<Identifier> groupingSet, Set<FunctionCall> aggregations, boolean notExists, List<Property> properties) {
        this(Optional.of(location), cubeName, sourceTableName, groupingSet, aggregations, notExists, properties);
    }

    private CreateCube(Optional<NodeLocation> location, QualifiedName cubeName, QualifiedName sourceTableName, List<Identifier> groupingSet, Set<FunctionCall> aggregations, boolean notExists, List<Property> properties) {
        super(location);
        this.cubeName = Objects.requireNonNull(cubeName, "cube name is null");
        this.sourceTableName = Objects.requireNonNull(sourceTableName, "table name is null");
        this.groupingSet = groupingSet;
        this.aggregations = aggregations;
        this.notExists = notExists;
        this.properties = properties;
    }

    public QualifiedName getCubeName() {
        return this.cubeName;
    }

    public QualifiedName getSourceTableName() {
        return this.sourceTableName;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Identifier> getGroupingSet() {
        return this.groupingSet;
    }

    public Set<FunctionCall> getAggregations() {
        return this.aggregations;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateCube(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().addAll(this.aggregations).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cubeName, this.sourceTableName, this.groupingSet, this.aggregations, this.notExists, this.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cubeName", (Object)this.cubeName).add("tableName", (Object)this.sourceTableName).add("groupingSet", this.groupingSet).add("aggregations", this.aggregations).add("notExists", this.notExists).add("properties", this.properties).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCube)) {
            return false;
        }
        CreateCube that = (CreateCube)o;
        return Objects.equals(this.cubeName, that.cubeName) && Objects.equals(this.sourceTableName, that.sourceTableName) && Objects.equals(this.groupingSet, that.groupingSet) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.notExists, that.notExists) && Objects.equals(this.properties, that.properties);
    }
}

