/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Cache
extends Statement {
    private final QualifiedName tableName;
    private final Optional<Expression> where;

    public Cache(QualifiedName tableName) {
        this(Optional.empty(), tableName, Optional.empty());
    }

    public Cache(QualifiedName tableName, Optional<Expression> where) {
        this(Optional.empty(), tableName, where);
    }

    public Cache(NodeLocation location, QualifiedName tableName, Optional<Expression> where) {
        this(Optional.of(location), tableName, where);
    }

    private Cache(Optional<NodeLocation> location, QualifiedName tableName, Optional<Expression> where) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "table is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Identifier getName() {
        return new Identifier(this.tableName.toString() + ".cache");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCache(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().add((Object)this.getName()).build();
    }

    @Override
    public String toString() {
        return "Cache{tableName=" + this.tableName + ", where=" + (this.where.isPresent() ? this.where.get().toString() : "null") + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cache cache = (Cache)o;
        return Objects.equals(this.tableName, cache.tableName) && Objects.equals(this.where, cache.where);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.where);
    }
}

