/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    public void checkCanImpersonateUser(Identity identity, String userName) {
        this.delegate().checkCanImpersonateUser(identity, userName);
    }

    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(identity, propertyName);
    }

    public void checkCanAccessCatalog(Identity identity, String catalogName) {
        this.delegate().checkCanAccessCatalog(identity, catalogName);
    }

    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return this.delegate().filterCatalogs(identity, catalogs);
    }

    public void checkCanShowCatalogs(Identity identity) {
        this.delegate().checkCanShowCatalogs(identity);
    }

    public void checkCanCreateCatalog(Identity identity, String catalogName) {
        this.delegate().checkCanCreateCatalog(identity, catalogName);
    }

    public void checkCanDropCatalog(Identity identity, String catalogName) {
        this.delegate().checkCanDropCatalog(identity, catalogName);
    }

    public void checkCanUpdateCatalog(Identity identity, String catalogName) {
        this.delegate().checkCanUpdateCatalog(identity, catalogName);
    }

    public void checkCanCreateSchema(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(identity, schema);
    }

    public void checkCanDropSchema(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(identity, schema);
    }

    public void checkCanRenameSchema(Identity identity, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(identity, schema, newSchemaName);
    }

    public void checkCanShowSchemas(Identity identity, String catalogName) {
        this.delegate().checkCanShowSchemas(identity, catalogName);
    }

    public Set<String> filterSchemas(Identity identity, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(identity, catalogName, schemaNames);
    }

    public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanCreateTable(identity, table);
    }

    public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(identity, table);
    }

    public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(identity, table, newTable);
    }

    public void checkCanSetTableComment(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanSetTableComment(identity, table);
    }

    public void checkCanShowTablesMetadata(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanShowTablesMetadata(identity, schema);
    }

    public Set<SchemaTableName> filterTables(Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(identity, catalogName, tableNames);
    }

    public void checkCanShowColumnsMetadata(Identity identity, CatalogSchemaTableName tableName) {
        this.delegate().checkCanShowColumnsMetadata(identity, tableName);
    }

    public List<ColumnMetadata> filterColumns(Identity identity, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return this.delegate().filterColumns(identity, tableName, columns);
    }

    public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(identity, table);
    }

    public void checkCanDropColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(identity, table);
    }

    public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(identity, table);
    }

    public void checkCanSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(identity, table, columns);
    }

    public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(identity, table);
    }

    public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(identity, table);
    }

    public void checkCanUpdateTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanUpdateTable(identity, table);
    }

    public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(identity, view);
    }

    public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(identity, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(identity, table, columns);
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(identity, catalogName, propertyName);
    }

    public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(identity, privilege, table, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate().checkCanRevokeTablePrivilege(identity, privilege, table, revokee, grantOptionFor);
    }

    public void checkCanShowRoles(Identity identity, String catalogName) {
        this.delegate().checkCanShowRoles(identity, catalogName);
    }

    public void checkCanAccessNodeInfo(Identity identity) {
        this.delegate().checkCanAccessNodeInfo(identity);
    }

    public Optional<ViewExpression> getRowFilter(Identity identity, CatalogSchemaTableName tableName) {
        return this.delegate().getRowFilter(identity, tableName);
    }

    public Optional<ViewExpression> getColumnMask(Identity identity, CatalogSchemaTableName tableName, String columnName, Type type) {
        return this.delegate().getColumnMask(identity, tableName, columnName, type);
    }

    public void checkCanCreateIndex(Identity identity, CatalogSchemaTableName index) {
        this.delegate().checkCanCreateIndex(identity, index);
    }

    public void checkCanDropIndex(Identity identity, CatalogSchemaTableName index) {
        this.delegate().checkCanDropIndex(identity, index);
    }

    public void checkCanRenameIndex(Identity identity, CatalogSchemaTableName index, CatalogSchemaTableName newIndex) {
        this.delegate().checkCanRenameIndex(identity, index, newIndex);
    }

    public void checkCanUpdateIndex(Identity identity, CatalogSchemaTableName index) {
        this.delegate().checkCanUpdateIndex(identity, index);
    }

    public void checkCanShowIndex(Identity identity, CatalogSchemaTableName index) {
        this.delegate().checkCanShowIndex(identity, index);
    }
}

