/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.optimization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.optimization.BaseJdbcRowExpressionConverter;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizerUtils;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownModule;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownParameter;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorContext;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorResult;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.metadata.TableHandle;
import io.prestosql.spi.plan.AggregationNode;
import io.prestosql.spi.plan.FilterNode;
import io.prestosql.spi.plan.GroupIdNode;
import io.prestosql.spi.plan.JoinNode;
import io.prestosql.spi.plan.LimitNode;
import io.prestosql.spi.plan.MarkDistinctNode;
import io.prestosql.spi.plan.OrderingScheme;
import io.prestosql.spi.plan.PlanNode;
import io.prestosql.spi.plan.PlanVisitor;
import io.prestosql.spi.plan.ProjectNode;
import io.prestosql.spi.plan.Symbol;
import io.prestosql.spi.plan.TableScanNode;
import io.prestosql.spi.plan.TopNNode;
import io.prestosql.spi.plan.UnionNode;
import io.prestosql.spi.plan.WindowNode;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.relation.RowExpressionVisitor;
import io.prestosql.spi.sql.QueryGenerator;
import io.prestosql.spi.sql.RowExpressionConverter;
import io.prestosql.spi.sql.SqlStatementWriter;
import io.prestosql.spi.sql.expression.OrderBy;
import io.prestosql.spi.sql.expression.Selection;
import io.prestosql.spi.sql.expression.Types;
import io.prestosql.spi.type.TypeManager;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BaseJdbcQueryGenerator
implements QueryGenerator<JdbcQueryGeneratorResult, JdbcConverterContext> {
    protected static final Logger log = Logger.get(BaseJdbcQueryGenerator.class);
    protected static final String GENERATE_FAILED_LOG = "JDBC query generator failed for [%s]";
    protected final String quote;
    protected final JdbcPushDownModule pushDownModule;
    protected final BaseJdbcRowExpressionConverter converter;
    protected final SqlStatementWriter statementWriter;

    public BaseJdbcQueryGenerator(JdbcPushDownParameter pushDownParameter, BaseJdbcRowExpressionConverter converter, SqlStatementWriter statementWriter) {
        this.quote = pushDownParameter.getIdentifierQuote();
        this.pushDownModule = pushDownParameter.getPushDownModuleParameter() == JdbcPushDownModule.DEFAULT ? JdbcPushDownModule.FULL_PUSHDOWN : pushDownParameter.getPushDownModuleParameter();
        this.converter = converter;
        this.statementWriter = statementWriter;
    }

    public BaseJdbcRowExpressionConverter getConverter() {
        return this.converter;
    }

    public Optional<JdbcQueryGeneratorResult> generate(PlanNode plan, TypeManager typeManager) {
        try {
            Optional context = (Optional)Objects.requireNonNull(plan.accept(this.getVisitor(typeManager), null), "Resulting context is null");
            return context.map(jdbcQueryGeneratorContext -> new JdbcQueryGeneratorResult(this.buildSql((JdbcQueryGeneratorContext)jdbcQueryGeneratorContext), (JdbcQueryGeneratorContext)jdbcQueryGeneratorContext));
        }
        catch (PrestoException e) {
            log.debug((Throwable)e, "Possibly benign error when pushing plan into scan node %s", new Object[]{plan});
            return Optional.empty();
        }
    }

    protected PlanVisitor<Optional<JdbcQueryGeneratorContext>, Void> getVisitor(TypeManager typeManager) {
        return new BaseJdbcPlanVisitor(typeManager);
    }

    protected JdbcQueryGeneratorResult.GeneratedSql buildSql(JdbcQueryGeneratorContext context) {
        String sql = this.statementWriter.select((List)ImmutableList.copyOf(context.getSelections().values()));
        Preconditions.checkArgument((boolean)context.getFrom().isPresent(), (Object)"From expression must not be empty");
        sql = this.statementWriter.from(sql, context.getFrom().get());
        if (context.getFilter().isPresent()) {
            sql = this.statementWriter.filter(sql, context.getFilter().get());
        }
        if (!context.getGroupByColumns().isEmpty()) {
            sql = this.statementWriter.groupBy(sql, context.getGroupByColumns());
        }
        if (context.getOrderBy().isPresent()) {
            sql = this.statementWriter.orderBy(sql, context.getOrderBy().get());
        }
        if (context.getLimit().isPresent()) {
            sql = this.statementWriter.limit(sql, context.getLimit().getAsLong());
        }
        boolean isPushDown = context.isHasPushDown();
        return new JdbcQueryGeneratorResult.GeneratedSql(sql, isPushDown);
    }

    protected class BaseJdbcPlanVisitor
    extends PlanVisitor<Optional<JdbcQueryGeneratorContext>, Void> {
        protected int derivedTableIdentifier = 1;
        protected TypeManager typeManager;

        public BaseJdbcPlanVisitor(TypeManager typeManager) {
            this.typeManager = typeManager;
        }

        public Optional<JdbcQueryGeneratorContext> visitPlan(PlanNode node, Void contextIn) {
            log.debug(BaseJdbcQueryGenerator.GENERATE_FAILED_LOG, new Object[]{"Don't know how to handle plan node of type " + node});
            return Optional.empty();
        }

        public Optional<JdbcQueryGeneratorContext> visitMarkDistinct(MarkDistinctNode node, Void contextIn) {
            return (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
        }

        public Optional<JdbcQueryGeneratorContext> visitFilter(FilterNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            JdbcConverterContext jdbcConverterContext = new JdbcConverterContext();
            String filter = (String)node.getPredicate().accept((RowExpressionVisitor)BaseJdbcQueryGenerator.this.converter, (Object)jdbcConverterContext);
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(context).setSelections(JdbcPlanOptimizerUtils.getProjectSelections(context.getSelections())).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql(context).getSql(), this.derivedTableIdentifier++)).setFilter(Optional.of(filter)).setOutputColumns(node.getOutputSymbols()).setHasPushDown(true).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitJoin(JoinNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional leftSourceContext = (Optional)node.getLeft().accept((PlanVisitor)this, (Object)contextIn);
            if (!leftSourceContext.isPresent()) {
                return Optional.empty();
            }
            Optional rightSourceContext = (Optional)node.getRight().accept((PlanVisitor)this, (Object)contextIn);
            if (!rightSourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext leftContext = (JdbcQueryGeneratorContext)leftSourceContext.get();
            JdbcQueryGeneratorContext rightContext = (JdbcQueryGeneratorContext)rightSourceContext.get();
            if (!(leftContext.getCatalogName().isPresent() && rightContext.getCatalogName().isPresent() && leftContext.getCatalogName().equals(rightContext.getCatalogName()))) {
                log.debug(BaseJdbcQueryGenerator.GENERATE_FAILED_LOG, new Object[]{"Jdbc Generator can only push down join node with same catalog"});
                return Optional.empty();
            }
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>();
            newSelections.putAll(JdbcPlanOptimizerUtils.getProjectSelections(leftContext.getSelections()));
            newSelections.putAll(JdbcPlanOptimizerUtils.getProjectSelections(rightContext.getSelections()));
            String from = BaseJdbcQueryGenerator.this.statementWriter.join((node.isCrossJoin() ? Types.JoinType.CROSS : Types.JoinType.valueOf((String)node.getType().toString())).getJoinLabel(), BaseJdbcQueryGenerator.this.buildSql(leftContext).getSql(), BaseJdbcQueryGenerator.this.buildSql(rightContext).getSql(), node.getCriteria().stream().map(JoinNode.EquiJoinClause::toString).collect(Collectors.toList()), node.getFilter().map(filter -> {
                JdbcConverterContext jdbcConverterContext = new JdbcConverterContext();
                return (String)filter.accept((RowExpressionVisitor)BaseJdbcQueryGenerator.this.converter, (Object)jdbcConverterContext);
            }), this.derivedTableIdentifier++);
            JdbcQueryGeneratorContext.Builder contextBuilder = JdbcQueryGeneratorContext.buildAsNewTable(leftContext).setSelections(newSelections).setFrom(Optional.of(from)).setHasPushDown(true).setOutputColumns(node.getOutputSymbols());
            return Optional.of(contextBuilder.build());
        }

        public Optional<JdbcQueryGeneratorContext> visitUnion(UnionNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            List sources = node.getSources();
            if (sources == null || sources.size() < 2) {
                log.debug(BaseJdbcQueryGenerator.GENERATE_FAILED_LOG, new Object[]{"Does not support tables' num smaller than 2 in union node"});
                return Optional.empty();
            }
            List sourceContexts = sources.stream().map(planNode -> (Optional)planNode.accept((PlanVisitor)this, (Object)contextIn)).collect(Collectors.toList());
            if (!sourceContexts.stream().allMatch(Optional::isPresent)) {
                return Optional.empty();
            }
            List<JdbcQueryGeneratorContext> contexts = sourceContexts.stream().map(Optional::get).collect(Collectors.toList());
            if (!JdbcPlanOptimizerUtils.isSameCatalog(contexts)) {
                log.debug(BaseJdbcQueryGenerator.GENERATE_FAILED_LOG, new Object[]{"Union push down just support all sources in same catalog"});
                return Optional.empty();
            }
            String from = BaseJdbcQueryGenerator.this.statementWriter.union(IntStream.range(0, sources.size()).mapToObj(i -> BaseJdbcQueryGenerator.this.statementWriter.from(BaseJdbcQueryGenerator.this.statementWriter.select(JdbcPlanOptimizerUtils.getSelectionsFromSymbolsMap(node.sourceSymbolMap(i))), JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql((JdbcQueryGeneratorContext)contexts.get(i)).getSql(), this.derivedTableIdentifier++).get())).collect(Collectors.toList()), this.derivedTableIdentifier++);
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>();
            node.getOutputSymbols().forEach(symbol -> newSelections.put(symbol.getName(), new Selection(symbol.getName(), symbol.getName())));
            JdbcQueryGeneratorContext baseContext = contexts.get(0);
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(baseContext).setSelections(newSelections).setFrom(Optional.of(from)).setHasPushDown(true).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitProject(ProjectNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            Map assignments = node.getAssignments().getMap();
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>(JdbcPlanOptimizerUtils.getProjectSelections(context.getSelections()));
            for (Map.Entry entry : assignments.entrySet()) {
                JdbcConverterContext jdbcConverterContext = new JdbcConverterContext();
                newSelections.put(((Symbol)entry.getKey()).getName(), new Selection((String)((RowExpression)entry.getValue()).accept((RowExpressionVisitor)BaseJdbcQueryGenerator.this.converter, (Object)jdbcConverterContext), ((Symbol)entry.getKey()).getName()));
            }
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(context).setHasPushDown(true).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql(context).getSql(), this.derivedTableIdentifier++)).setSelections(newSelections).setOutputColumns(node.getOutputSymbols()).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitAggregation(AggregationNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            Preconditions.checkArgument((!node.getStep().isOutputPartial() ? 1 : 0) != 0, (Object)"partial aggregations are not support in Jdbc pushdown framework");
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>();
            LinkedHashSet<String> groupByColumns = new LinkedHashSet<String>();
            for (Symbol outputColumn : node.getOutputSymbols()) {
                AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)node.getAggregations().get(outputColumn);
                if (aggregation != null) {
                    if (aggregation.getFilter().isPresent() || aggregation.getOrderingScheme().isPresent()) {
                        log.debug(BaseJdbcQueryGenerator.GENERATE_FAILED_LOG, new Object[]{"Not support aggregation node " + node});
                        return Optional.empty();
                    }
                    String aggExpression = BaseJdbcQueryGenerator.this.statementWriter.aggregation(aggregation.getFunctionCall().getDisplayName(), aggregation.getArguments().stream().map(rowExpression -> {
                        JdbcConverterContext jdbcConverterContext = new JdbcConverterContext();
                        return (String)rowExpression.accept((RowExpressionVisitor)BaseJdbcQueryGenerator.this.converter, (Object)jdbcConverterContext);
                    }).collect(Collectors.toList()), JdbcPlanOptimizerUtils.isAggregationDistinct(aggregation));
                    String castAggExpression = BaseJdbcQueryGenerator.this.statementWriter.castAggregationType(aggExpression, (RowExpressionConverter)BaseJdbcQueryGenerator.this.converter, aggregation.getFunctionCall().getType());
                    newSelections.put(outputColumn.getName(), new Selection(castAggExpression, outputColumn.getName()));
                    continue;
                }
                newSelections.put(outputColumn.getName(), new Selection(outputColumn.getName()));
                groupByColumns.add(outputColumn.getName());
            }
            Optional groupIdSymbol = node.getGroupIdSymbol();
            if (groupIdSymbol.isPresent() && ((JdbcQueryGeneratorContext)sourceContext.get()).getGroupIdNodeInfo().getGroupingElementStore().containsKey(groupIdSymbol.get())) {
                JdbcQueryGeneratorContext.GroupIdNodeInfo groupIdNodeInfo = ((JdbcQueryGeneratorContext)sourceContext.get()).getGroupIdNodeInfo();
                String idElementString = groupIdNodeInfo.getGroupingElementStore().get(groupIdSymbol.get());
                Optional<String> eleStr = Optional.of(idElementString);
                Optional<Selection> selectionOptional = Optional.empty();
                for (Map.Entry<String, Selection> entry : newSelections.entrySet()) {
                    String selectStr = entry.getValue().getExpression();
                    if (!selectStr.equals(((Symbol)groupIdSymbol.get()).getName())) continue;
                    selectionOptional = Optional.of(entry.getValue());
                }
                selectionOptional.ifPresent(selection -> {
                    Selection cfr_ignored_0 = (Selection)newSelections.remove(selection.getAlias());
                });
                groupIdNodeInfo.setGroupByComplexOperation(true);
                return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable((JdbcQueryGeneratorContext)sourceContext.get()).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql((JdbcQueryGeneratorContext)sourceContext.get()).getSql(), this.derivedTableIdentifier++)).setSelections(newSelections).setGroupIdNodeInfo(groupIdNodeInfo).setGroupByColumns((Set<String>)ImmutableSet.of((Object)eleStr.get())).build());
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(context).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql(context).getSql(), this.derivedTableIdentifier++)).setSelections(newSelections).setGroupByColumns(groupByColumns).setHasPushDown(true).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitTableScan(TableScanNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Preconditions.checkArgument((boolean)(node.getTable().getConnectorHandle() instanceof JdbcTableHandle), (Object)"Expected to find jdbc table handle for the scan node");
            TupleDomain constraint = node.getEnforcedConstraint();
            if (constraint != null && constraint.getDomains().isPresent() && !((Map)constraint.getDomains().get()).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Cannot push down table scan with predicates pushed down");
            }
            TableHandle tableHandle = node.getTable();
            JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)node.getTable().getConnectorHandle();
            Preconditions.checkArgument((!jdbcTableHandle.getGeneratedSql().isPresent() ? 1 : 0) != 0, (Object)"Jdbc tableHandle should not have sql before pushdown");
            LinkedHashMap<String, Selection> selections = new LinkedHashMap<String, Selection>();
            node.getOutputSymbols().forEach(outputColumn -> {
                JdbcColumnHandle jdbcColumn = (JdbcColumnHandle)node.getAssignments().get(outputColumn);
                selections.put(outputColumn.getName(), new Selection(jdbcColumn.getColumnName(), outputColumn.getName()));
            });
            StringBuilder table = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)jdbcTableHandle.getCatalogName())) {
                table.append(JdbcPlanOptimizerUtils.quote(BaseJdbcQueryGenerator.this.quote, jdbcTableHandle.getCatalogName())).append('.');
            }
            if (!Strings.isNullOrEmpty((String)jdbcTableHandle.getSchemaName())) {
                table.append(JdbcPlanOptimizerUtils.quote(BaseJdbcQueryGenerator.this.quote, jdbcTableHandle.getSchemaName())).append('.');
            }
            table.append(JdbcPlanOptimizerUtils.quote(BaseJdbcQueryGenerator.this.quote, jdbcTableHandle.getTableName()));
            JdbcQueryGeneratorContext.Builder contextBuilder = new JdbcQueryGeneratorContext.Builder().setCatalogName(Optional.of(tableHandle.getCatalogName())).setTransaction(Optional.of(tableHandle.getTransaction())).setSchemaTableName(Optional.of(jdbcTableHandle.getSchemaTableName())).setSelections(selections).setFrom(Optional.of(table.toString()));
            if (jdbcTableHandle.getLimit().isPresent()) {
                contextBuilder.setLimit(jdbcTableHandle.getLimit());
                contextBuilder.setHasPushDown(true);
            }
            return Optional.of(contextBuilder.build());
        }

        public Optional<JdbcQueryGeneratorContext> visitWindow(WindowNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            List partitionBy = node.getPartitionBy().stream().map(Symbol::getName).collect(Collectors.toList());
            Optional<Object> orderBy = Optional.empty();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme scheme = (OrderingScheme)node.getOrderingScheme().get();
                orderBy = Optional.of(BaseJdbcQueryGenerator.this.statementWriter.orderBy("", scheme.getOrderBy().stream().map(symbol -> new OrderBy(symbol.getName(), scheme.getOrdering(symbol))).collect(Collectors.toList())));
            }
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>(JdbcPlanOptimizerUtils.getProjectSelections(context.getSelections()));
            for (Map.Entry functionEntry : node.getWindowFunctions().entrySet()) {
                Optional<String> endBound;
                Optional<String> startBound;
                Optional<String> startValue;
                Types.WindowFrameType windowFrameType;
                Symbol windowFunctionColumnName = (Symbol)functionEntry.getKey();
                WindowNode.Function windowFunction = (WindowNode.Function)functionEntry.getValue();
                WindowNode.Frame frame = windowFunction.getFrame();
                if (frame.getType() == Types.WindowFrameType.RANGE) {
                    windowFrameType = Types.WindowFrameType.RANGE;
                } else if (frame.getType() == Types.WindowFrameType.ROWS) {
                    windowFrameType = Types.WindowFrameType.ROWS;
                } else {
                    throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Does not support unknown frame type in " + node.getClass().getName());
                }
                Types.FrameBoundType startType = frame.getStartType();
                Types.FrameBoundType endType = frame.getEndType();
                if (frame.getStartValue().isPresent() && frame.getOriginalEndValue().isPresent()) {
                    if (!frame.getOriginalStartValue().isPresent() || !frame.getOriginalEndValue().isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Does not support unknown 2 frame bound value in " + node.getClass().getName());
                    }
                    startValue = Optional.of(frame.getOriginalStartValue().get());
                    startBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(startType, startValue));
                    Optional<String> endValue = Optional.of(frame.getOriginalEndValue().get());
                    endBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(endType, endValue));
                } else if (frame.getStartValue().isPresent() && !frame.getEndValue().isPresent()) {
                    if (!frame.getOriginalStartValue().isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Does not support start frame bound value in " + node.getClass().getName());
                    }
                    startValue = Optional.of(frame.getOriginalStartValue().get());
                    startBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(startType, startValue));
                    endBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(endType, Optional.empty()));
                } else if (!frame.getStartValue().isPresent() && !frame.getEndValue().isPresent()) {
                    startBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(startType, Optional.empty()));
                    endBound = Optional.of(JdbcPlanOptimizerUtils.frameBound(endType, Optional.empty()));
                } else {
                    throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, "Does not support unknown frame start and end value in " + node.getClass().getName());
                }
                Optional<String> frameStr = startBound.map(s -> BaseJdbcQueryGenerator.this.statementWriter.windowFrame(windowFrameType, s, endBound));
                List expArgs = windowFunction.getArguments();
                List functionArgs = expArgs.stream().map(expression -> {
                    JdbcConverterContext jdbcConverterContext = new JdbcConverterContext();
                    return (String)expression.accept((RowExpressionVisitor)BaseJdbcQueryGenerator.this.converter, (Object)jdbcConverterContext);
                }).collect(Collectors.toList());
                String columnStr = BaseJdbcQueryGenerator.this.statementWriter.window(windowFunction.getFunctionCall().getDisplayName(), functionArgs, partitionBy, orderBy, frameStr);
                newSelections.put(windowFunctionColumnName.toString(), new Selection(columnStr, windowFunctionColumnName.toString()));
            }
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(context).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql(context).getSql(), this.derivedTableIdentifier++)).setHasPushDown(true).setSelections(newSelections).setOutputColumns(node.getOutputSymbols()).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitLimit(LimitNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            if (node.isPartial()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Jdbc query generator cannot handle partial limit");
            }
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            return Optional.of(JdbcQueryGeneratorContext.buildFrom(context).setHasPushDown(true).setLimit(OptionalLong.of(node.getCount())).setOutputColumns(node.getOutputSymbols()).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitTopN(TopNNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            if (!node.getStep().equals((Object)TopNNode.Step.SINGLE)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "JDBC query generator can only push single logical topN");
            }
            JdbcQueryGeneratorContext context = (JdbcQueryGeneratorContext)sourceContext.get();
            OrderingScheme scheme = node.getOrderingScheme();
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable(context).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql(context).getSql(), this.derivedTableIdentifier++)).setHasPushDown(true).setSelections(JdbcPlanOptimizerUtils.getProjectSelections(context.getSelections())).setLimit(OptionalLong.of(node.getCount())).setOrderBy(Optional.of(scheme.getOrderBy().stream().map(symbol -> new OrderBy(symbol.getName(), scheme.getOrdering(symbol))).collect(Collectors.toList()))).setOutputColumns(node.getOutputSymbols()).build());
        }

        public Optional<JdbcQueryGeneratorContext> visitGroupId(GroupIdNode node, Void contextIn) {
            this.checkAvailable((PlanNode)node);
            Optional sourceContext = (Optional)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            if (!sourceContext.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext.GroupIdNodeInfo groupIdNodeInfo = ((JdbcQueryGeneratorContext)sourceContext.get()).getGroupIdNodeInfo();
            String groupingsSets = BaseJdbcQueryGenerator.this.statementWriter.groupingsSets(node.getGroupingSets().stream().map(list -> list.stream().map(Symbol::getName).collect(Collectors.toList())).collect(Collectors.toList()));
            Symbol groupIdSymbol = node.getGroupIdSymbol();
            groupIdNodeInfo.getGroupingElementStore().put(groupIdSymbol, groupingsSets);
            LinkedHashMap<String, Selection> newSelections = new LinkedHashMap<String, Selection>();
            node.getGroupingColumns().forEach((key, value) -> newSelections.put(key.getName(), new Selection(value.getName(), key.getName())));
            node.getAggregationArguments().forEach(symbol -> newSelections.put(symbol.getName(), new Selection(symbol.getName())));
            return Optional.of(JdbcQueryGeneratorContext.buildAsNewTable((JdbcQueryGeneratorContext)sourceContext.get()).setFrom(JdbcPlanOptimizerUtils.getDerivedTable(BaseJdbcQueryGenerator.this.buildSql((JdbcQueryGeneratorContext)sourceContext.get()).getSql(), this.derivedTableIdentifier++)).setGroupIdNodeInfo(groupIdNodeInfo).setSelections(newSelections).build());
        }

        protected void checkAvailable(PlanNode node) {
            if (!BaseJdbcQueryGenerator.this.pushDownModule.isAvailable(node)) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_QUERY_GENERATOR_FAILURE, String.format("The node [%s] is not support to push down in mode [%s]", new Object[]{node.getClass().getSimpleName(), BaseJdbcQueryGenerator.this.pushDownModule}));
            }
        }
    }
}

