/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import io.hetu.core.plugin.datacenter.DataCenterQueryRunner;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.tests.AbstractTestIntegrationSmokeTest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestDCIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private final TestingPrestoServer hetuServer;

    public TestDCIntegrationSmokeTest() throws Exception {
        this(new TestingPrestoServer((Map)ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"true").build()));
    }

    public TestDCIntegrationSmokeTest(TestingPrestoServer hetuServer) {
        super(() -> DataCenterQueryRunner.createDCQueryRunner(hetuServer, TpchTable.ORDERS));
        this.hetuServer = hetuServer;
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        this.hetuServer.close();
    }

    @Test
    public void testShow() {
        List rows = this.computeActual("show catalogs").getMaterializedRows();
        Assert.assertTrue((boolean)rows.stream().anyMatch(row -> row.getField(0).equals("dc.tpch")));
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)this.computeActual("show schemas from dc.tpch").getMaterializedRows(), (Collection)this.computeActual("show schemas from tpch").getMaterializedRows());
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)this.computeActual("show tables from dc.tpch.tiny").getMaterializedRows(), (Collection)this.computeActual("show tables from tpch.tiny").getMaterializedRows());
    }

    @Test
    public void testUse() {
        this.assertQuerySucceeds("use dc.tpch.tiny");
    }

    @Test
    public void testSelect() {
        io.prestosql.testing.assertions.Assert.assertEquals((String)this.computeActual("select count(*) from dc.tpch.tiny.orders").toString(), (String)this.computeActual("select count(*) from tpch.tiny.orders").toString());
        List actual = this.computeActual("select * from dc.tpch.tiny.orders order by orderkey limit 10").getMaterializedRows();
        List expect = this.computeActual("select * from tpch.tiny.orders order by orderkey limit 10").getMaterializedRows();
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)actual, (Collection)expect);
    }
}

